package com.bringspring.common.annotation;

import java.lang.annotation.*;

/**
 * 任务调度注解
 *
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/9 11:28
 */
@Documented
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface JsbosTask {

    /**
     * id
     */
    String id() default "";

    /**
     * 方法名（必填）
     *
     * @return
     */
    String fullName() default "";

    /**
     * 任务说明
     *
     * @return
     */
    String description() default "";

    /**
     * 表达式（必填）
     *
     * @return
     */
    String cron() default "";

    /**
     * 开始时间
     *
     * @return
     */
    String startDate() default "";

    /**
     * 结束时间
     *
     * @return
     */
    String endDate() default "";

    /**
     * 参数类型
     */
    Class[] parameterType() default {};

    /**
     * 值
     */
    String parameterValue() default "";
}
