package com.bringspring.common.auth.config;

import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.jwt.StpLogicJwtForSimple;
import cn.dev33.satoken.stp.StpLogic;
import com.bringspring.common.auth.consts.AuthConsts;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;


/**
 * @author JNPF开发平台组
 * @copyright 引迈信息技术有限公司
 */
@Configuration
public class AuthAutoConfigration {


    @Primary
    @Bean
    @ConfigurationProperties(prefix = "oauth.login")
    public SaTokenConfig getJnpfTokenConfig() {
        return new JnpfTokenConfig();
    }


    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix = JnpfOauthConfig.PREFIX)
    public JnpfOauthConfig getJnpfOauthConfig() {
        return new JnpfOauthConfig();
    }

    @Primary
    @Bean(AuthConsts.ACCOUNT_LOGIC_BEAN_DEFAULT)
    public StpLogic getJnpfTokenJwtLogic() {
        return new StpLogicJwtForSimple(AuthConsts.ACCOUNT_TYPE_DEFAULT);
    }

    @Bean(AuthConsts.ACCOUNT_LOGIC_BEAN_TENANT)
    public StpLogic getJnpfTenantTokenJwtLogic() {
        return new StpLogicJwtForSimple(AuthConsts.ACCOUNT_TYPE_TENANT);
    }
}
