package com.bringspring.common.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bringspring.common.constant.TableFieldsNameConst;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode
public abstract class SuperBaseEntity implements Serializable {


    @Data
    @ToString(callSuper = true)
    @EqualsAndHashCode
    public static abstract class SuperIBaseEntity<T> extends SuperBaseEntity {

        /**
         * 主键
         */
        @TableId(TableFieldsNameConst.FID)
        public T id;

    }


    @Data
    @ToString(callSuper = true)
    @EqualsAndHashCode
    public static abstract class SuperTBaseEntity<T> extends SuperIBaseEntity<T> {

        /**
         * 租户id
         */
        @TableField(value = TableFieldsNameConst.TENANT_ID , fill = FieldFill.INSERT_UPDATE)
        private String tenantId;

    }

    @Data
    @ToString(callSuper = true)
    @EqualsAndHashCode
    public static abstract class SuperCBaseEntity<T> extends SuperTBaseEntity<T> {

        /**
         * 创建时间
         */
        @TableField(value = TableFieldsNameConst.CREATOR_TIME , fill = FieldFill.INSERT)
        private Date creatorTime;

        /**
         * 创建用户
         */
        @TableField(value = TableFieldsNameConst.CREATOR_USER_ID , fill = FieldFill.INSERT)
        private String creatorUserId;

    }


    @Data
    @ToString(callSuper = true)
    @EqualsAndHashCode
    public static abstract class SuperCUBaseEntity<T> extends SuperCBaseEntity<T> {

        /**
         * 修改时间
         */
        @TableField(value = TableFieldsNameConst.LAST_MODIFY_TIME , fill = FieldFill.UPDATE)
        private Date lastModifyTime;

        /**
         * 修改用户
         */
        @TableField(value = TableFieldsNameConst.LAST_MODIFY_USER_ID , fill = FieldFill.UPDATE)
        private String lastModifyUserId;

    }


    @Data
    @ToString(callSuper = true)
    @EqualsAndHashCode
    public static abstract class SuperCUDBaseEntity<T> extends SuperCUBaseEntity<T> {

        /**
         * 删除标志
         */
        @TableField(value = TableFieldsNameConst.DELETE_MARK , updateStrategy = FieldStrategy.ALWAYS)
        private Integer deleteMark;

        /**
         * 删除时间
         */
        @TableField(value = TableFieldsNameConst.DELETE_TIME , fill = FieldFill.UPDATE)
        private Date deleteTime;

        /**
         * 删除用户
         */
        @TableField(value = TableFieldsNameConst.DELETE_USER_ID , fill = FieldFill.UPDATE)
        private String deleteUserId;
    }

    @Data
    @ToString(callSuper = true)
    @EqualsAndHashCode
    public static abstract class SuperCDBaseEntity<T> extends SuperCBaseEntity<T> {

        /**
         * 删除标志
         */
        @TableField(value = TableFieldsNameConst.DELETE_MARK , updateStrategy = FieldStrategy.ALWAYS)
        private Integer deleteMark;

        /**
         * 删除时间
         */
        @TableField(value = TableFieldsNameConst.DELETE_TIME , fill = FieldFill.UPDATE)
        private Date deleteTime;

        /**
         * 删除用户
         */
        @TableField(value = TableFieldsNameConst.DELETE_USER_ID , fill = FieldFill.UPDATE)
        private String deleteUserId;
    }


}

