package com.bringspring.common.constant;


/**
 * 缓存常量
 */
public interface CacheConsts {

    /**
     * 永久有效缓存空间
     */
    String FOREVER_CACHE = "foreverCacheSpace";
    /**
     * 短期有效缓存空间
     */
    String SHORT_CACHE = "shortCacheSpace";
    /**
     * 短期5分钟有效缓存空间
     */
    String FIVE_MINUTES_CACHE = "fiveMinutesCacheSpace";
    /**
     * 短期10分钟有效缓存空间
     */
    String TEN_MINUTES_CACHE = "tenMinutesCacheSpace";
    /**
     * 短期1小时有效缓存空间
     */
    String ONE_HOUR_CACHE = "oneHourCacheSpace";
    /**
     * 短期2小时有效缓存空间
     */
    String TWO_HOUR_CACHE = "twoHourCacheSpace";
    /**
     * 短期1天有效缓存空间
     */
    String ONE_DAY_CACHE = "oneDayCacheSpace";
    /**
     * 短期1周有效缓存空间
     */
    String ONE_WEEK_CACHE = "oneWeekCacheSpace";
    /**
     * 登录有效缓存空间
     */
    String LOGIN_CACHE = "loginCacheSpace";
    /**
     * JSSDKUtil缓存空间 指定的缓存策略
     */
    String JSSDKUTIL_CACHE = "JSSDKUtilCacheSpace";
    /**
     * 防重复提交缓存空间 指定的缓存策略
     */
    String REPEATSUBMIT_CACHE = "RepeatSubmitCacheSpace";

}
