package com.bringspring.common.database.datatype.limit;

import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.model.DtModel;
import com.bringspring.common.database.datatype.model.DtModelDTO;
import lombok.NoArgsConstructor;

/**
 * 时间数据类型
 *
 * @author JNPF开发平台组 YanYu
 * @version V3.3
 * @copyright 引迈信息技术有限公司
 * @date 2022-06-06
 */
@NoArgsConstructor
public class DateTimeLimit extends DtLimitBase {

    public final static String CATEGORY = "type-DateTime";
    public final static String JAVA_TYPE = "date";

    public DateTimeLimit(Boolean modify){
        this.isModifyFlag = modify;
    }

    @Override
    public String initDtCategory() {
        return CATEGORY;
    }

    @Override
    public DtModel convert(DtModelDTO dtModelDTO){
        DtModel dataTypeModel = new DtModel(dtModelDTO.getConvertTargetDtEnum());
        if(this.isModifyFlag){
            dataTypeModel.setFormatLengthStr("");
        }
        return dataTypeModel;
    }

}
