package com.bringspring.common.database.datatype.limit;

import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.limit.util.DtLimitUtil;
import com.bringspring.common.database.datatype.model.DtModel;
import com.bringspring.common.database.datatype.model.DtModelDTO;

/**
 * 小数数据类型
 *
 * @author JNPF开发平台组 YanYu
 * @version V3.3
 * @copyright 引迈信息技术有限公司
 * @date 2022-06-06
 */
public class DecimalLimit extends DtLimitBase {

    public final static String CATEGORY = "type-Decimal";
    public final static String JAVA_TYPE = "decimal";
    {this.dtCategory = CATEGORY;}

    public DecimalLimit(Boolean modify) {
        this.isModifyFlag = modify;
    }

    @Override
    public String initDtCategory() {
        return CATEGORY;
    }

    @Override
    public DtModel convert(DtModelDTO viewDtModel){
        DtModel dataTypeModel = DtLimitUtil.convertNumeric(viewDtModel);
        if(this.isModifyFlag){
            DtLimitUtil.getNumericLength(dataTypeModel);
        }
        return dataTypeModel;
    }

}
