package com.bringspring.common.database.datatype.limit;


import com.bringspring.common.database.datatype.db.DtMySQLEnum;
import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.limit.util.DtLimitUtil;
import com.bringspring.common.database.datatype.model.DtModel;
import com.bringspring.common.database.datatype.model.DtModelDTO;
import com.bringspring.common.database.datatype.sync.util.DtSyncUtil;
import com.bringspring.common.database.source.DbBase;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 整型数据类型
 *
 * @author JNPF开发平台组 YanYu
 * @version V3.3
 * @copyright 引迈信息技术有限公司
 * @date 2022-06-06
 */
@Data
@NoArgsConstructor
public class IntegerLimit extends DtLimitBase {

    public final static String CATEGORY = "type-Integer";
    public final static String JAVA_TYPE = "int";

    @Override
    public String initDtCategory() {
        return CATEGORY;
    }

    @Override
    public DtModel convert(DtModelDTO viewDtModel){
        DtInterface targetDtEnum = viewDtModel.getConvertTargetDtEnum();
        DtModel toModel = new DtModel(targetDtEnum);
        // 当转换成Oracle的数字类型
        if(targetDtEnum.getDtCategory().equals(NumberLimit.CATEGORY)){
            try{
                // 先当前数据库转成DtMySQL枚举
                DtMySQLEnum dtEnum = (DtMySQLEnum) DtSyncUtil.getToFixCovert(targetDtEnum, DbBase.MYSQL);
                // 在进行转换对比
                switch (dtEnum){
                    case TINY_INT:
                        toModel.setNumPrecision(3);
                        break;
                    case SMALL_INT:
                        toModel.setNumPrecision(5);
                        break;
                    case MEDIUM_INT:
                        toModel.setNumPrecision(7);
                        break;
                    case INT:
                        toModel.setNumPrecision(10);
                        break;
                    case BIGINT:
                        toModel.setNumPrecision(19);
                        break;
                    default:
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        if(this.isModifyFlag){
            toModel.setFormatLengthStr("");
        }
        return toModel;
    }

}
