package com.bringspring.common.database.datatype.model;


import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.limit.base.DtModelBase;
import com.bringspring.common.util.StringUtils;
import lombok.Data;

/**
 * 数据类型模型
 *
 * @author JNPF开发平台组 YanYu
 * @version V3.2.0
 * @copyright 引迈信息技术有限公司
 * @date 2021/10/25
 */
@Data
public class DtModel extends DtModelBase {

    /**
     * 显示长度
     */
    private String formatLengthStr;


    public DtModel(DtInterface dtEnum){
        this.dtEnum = dtEnum;
    }

    /**
     * 表字段数据类型名
     */
    public String getDataType(){
        return this.dtEnum.getDataType();
    }

    /**
     * java数据类型
     */
    public String getJavaType(){
        return this.dtEnum.getJavaType();
    }

    /**
     * 当精度（>=1）小于标度
     * 重置标度，让其小于精度(精度-1)
     */
    public void formatNumLength(Integer numPrecision, Integer numScale){
        if(numScale != null && numPrecision < numScale){
            this.numScale = numPrecision - 1;
        }
    }

    public String formatDataType(){
        String lengthInfo = getFormatLengthStr();
        return getDataType() + (StringUtils.isNotEmpty(lengthInfo) ? "(" + lengthInfo + ")" : "");
    }

}
