package com.bringspring.common.database.plugins;

import cn.dev33.satoken.context.SaHolder;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.function.Consumer;

public interface ITenantPlugin {

    default void printNoTenant(Consumer<NoTenantInfoModel> logConsumer) {
        String token = null;
        String url = null;
        String stack = null;
        String userId = UserProvider.getUser().getTenantId();
        try {
            token = UserProvider.getToken();
            url = SaHolder.getRequest().getRequestPath();
        } catch (Exception ignored) {
        }
        if (url == null) {
            try {
                stack = StringUtils.join(Thread.currentThread().getStackTrace(), "\n");
            } catch (Exception ignored) {
            }
        }
        logConsumer.accept(new NoTenantInfoModel(token, url, stack, userId));
    }

}

@Data
@AllArgsConstructor
class NoTenantInfoModel {
    private String token;
    private String url;
    private String stack;
    private String userId;
}