package com.bringspring.common.database.source.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.bringspring.common.database.constant.DbAliasConst;
import com.bringspring.common.database.constant.DbConst;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.enums.datatype.viewshow.DataTypeEnum;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.impl.SqlSQLServer;
import com.bringspring.common.database.sql.model.DbStruct;
import com.bringspring.common.exception.DataException;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * SQLServer模型
 *
 * @author RKKJ开发平台组 YY
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/10/06
 */
public class DbSQLServer extends DbBase {

    /**
     * 驱动程序无法通过使用安全套接字层(SSL)加密与 SQL Server 建立安全连接。
     * 错误:“sun.security.validator.ValidatorException: PKIX path building failed
     *
     * 可以尝试连接：jdbc:sqlserver://{host}:{port};databaseName={dbname};encrypt=true;trustServerCertificate=true
     */
    @Override
    protected void init() {
        setInstance(
                DbBase.SQL_SERVER,
                DbType.SQL_SERVER,
                "1433",
                "sqlserver",
                "com.microsoft.sqlserver.jdbc.SQLServerDriver",
                "jdbc:sqlserver://{host}:{port};databaseName={dbname}",
                new SqlSQLServer());
    }

    @Override
    public String getConnUrl(String prepareUrl, String host, Integer port, DbStruct struct) {
        prepareUrl = super.getConnUrl(prepareUrl, host, port, null);
        return prepareUrl.replace(DbConst.DB_NAME, struct.getSqlServerDbName()).replace(DbConst.DB_SCHEMA, struct.getSqlServerDbSchema());
    }

    @Override
    protected String getDynamicTableName(String tableName) {
        return DataSourceContextHolder.getDatasourceName()+".dbo." + tableName;
    }

    @Override
    public DbTableFieldModel getPartFieldModel(ResultSet result) throws SQLException, DataException {
        DbTableFieldModel model = new DbTableFieldModel();
        /*  Text 和 Image 是可能被 SQServer 以后的版本淘汰的数据类型
            varchar(max)-------text;
            nvarchar(max)-----ntext;
            varbinary(max)----p_w_picpath.
            查询出来只能显示nvarchar，长度-1的时候代表nvarchar(max)，项目中转换成text */
        // 字段类型
        String dataType = result.getString(DbAliasEnum.getAsByDb(this, DbAliasConst.DATA_TYPE));
        // 字段长度
        int dataLength = result.getInt(DbAliasEnum.getAsByDb(this, DbAliasConst.DATA_LENGTH));
        // nvarchar会显示-1
        if("nvarchar".equals(dataType) && dataLength == -1){
            model.setDataType(DataTypeEnum.TEXT.getViewFieldType());
            model.setDefaults("默认");
        }
        return model;
    }

}
