package com.bringspring.common.database.util;

/**
 * 调用setIsIgnoreLogicDelete 设置后续Mapper查询忽略字段多租户
 * 调用setDeleteAction 表示当前是删除操作
 *
 * @author JNPF开发平台组
 * @user N
 * @copyright 引迈信息技术有限公司
 * @date 2022/10/14 17:12
 */
public class LogicDeleteHelper {


    private static final ThreadLocal<Boolean> ISIGNORELOGICDELETE_HOLDER = new ThreadLocal<>();
    private static final ThreadLocal<Boolean> ISDELETEACTION_HOLDER = new ThreadLocal<>();

    public static boolean isIgnoreLogicDelete(){
        return Boolean.TRUE.equals(ISIGNORELOGICDELETE_HOLDER.get());
    }

    public static void setIgnoreLogicDelete(){
        ISIGNORELOGICDELETE_HOLDER.set(true);
    }

    public static void clearIgnoreLogicDelete(){
        ISIGNORELOGICDELETE_HOLDER.remove();
    }

    public static boolean isDeleteAction(){
        return Boolean.TRUE.equals(ISDELETEACTION_HOLDER.get());
    }

    public static void setDeleteAction(){
        ISDELETEACTION_HOLDER.set(true);
    }

    public static void clearDeleteAction(){
        ISDELETEACTION_HOLDER.remove();
    }

    public static boolean isMybatisPlusMethod(String msId){
        return msId.startsWith("com.baomidou.mybatisplus.core.injector.methods") || msId.startsWith("com.github.yulichang.method.mp");
    }

}
