package com.bringspring.common.exception;

import com.bringspring.common.constant.MsgCode;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * 数据库异常类
 *
 * @author RKKJ开发平台组 YanYu
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 10:10
 */
public class DataException extends RuntimeException {

    public DataException(){
        super();
    }

    public DataException(String message) {
        super(message);
    }

    public static DataException errorLink(String warning) {
        return new DataException(MsgCode.DB002.get() + warning );
    }

    public static SQLException rollbackDataException(SQLException e, Connection rollbackConn) {
        executeRollback(rollbackConn);
        return e;
    }

    /**
     * mysql表重复
     * @param error 错误信息
     */
    public static DataException tableExists(String error,Connection rollbackConn){
        executeRollback(rollbackConn);
        //Mysql英文报错，临时解决方案
        error = error.replace("Table","表").replace("already exists","已经存在。");
        return new DataException(error);
    }

    public static DataException rollbackDataException(String message, Connection rollbackConn) {
        executeRollback(rollbackConn);
        return new DataException(message);
    }

    private static void executeRollback(Connection conn){
        try {
            conn.rollback();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

}
