package com.bringspring.common.i18n.config;

import com.bringspring.common.constant.GlobalConst;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.boot.autoconfigure.context.MessageSourceProperties;

/**
 * 国际化配置类
 *
 * @author JNPF开发平台组
 * @user N
 * @copyright 引迈信息技术有限公司
 * @date 2024/3/21 14:00
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class I18nProperties extends MessageSourceProperties {

    /**
     * 未获取到语言设置时默认语言
     */
    private String defaultLanguage = GlobalConst.DEFAULT_LANGUAGE;

}
