package com.bringspring.common.license.controller;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.license.client.LicenseCheckListener;
import com.bringspring.common.license.client.LicenseManagerHolder;
import com.bringspring.common.license.license.CustomLicenseManager;
import com.bringspring.common.license.license.model.LicenseCheckModel;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.file.UploadUtil;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * 产品授权
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 20223年5月27日 上午9:18
 */
@Tag(name = "产品授权")
@RestController
@RequestMapping("/api/white/license")
@Slf4j
public class LicenseController {

    @Autowired
    private ConfigValueUtil configValueUtil;

    @Autowired
    private LicenseCheckListener licenseCheckListener;
    /**
     * 上传授权文件
     *
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "获取授权信息")
    @GetMapping(value = "/getLicenseInfo")
    public ActionResult getInfo(){
        CustomLicenseManager customLicenseManager=new CustomLicenseManager();
        LicenseCheckModel model = customLicenseManager.getServerInfos();
        String pcCode=Md5Util.getStringMd5(JSONObject.toJSONString(model));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("machineCode",pcCode);
        try {
            LicenseManager licenseManager = LicenseManagerHolder.getInstance(null);
            LicenseContent licenseContent = licenseManager.verify();
            jsonObject.put("isExist",true);
            jsonObject.put("startDate", licenseContent.getNotBefore());
            jsonObject.put("endDate", licenseContent.getNotAfter());
            jsonObject.put("extra", licenseContent.getExtra());
            jsonObject.put("info", licenseContent.getInfo());
            jsonObject.put("type", licenseContent.getConsumerType());
            return ActionResult.success(jsonObject);
        }catch (Exception e){
            jsonObject.put("isExist",false);
            ActionResult result = ActionResult.fail(ActionResultCode.LicenseError.getCode(), ActionResultCode.LicenseError.getMessage());
            result.setData(jsonObject);
            return  result;
        }
    }
    /**
     * 上传授权文件
     *
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "上传授权文件")
    @PostMapping(value = "/Uploader/{type}", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public ActionResult uploader(@RequestPart("file") MultipartFile file, @PathVariable("type") String type) throws LicenseContentException {
        String fileType = UpUtil.getFileType(file);
        //验证类型
        if (!"lic".equals(fileType)) {
            return ActionResult.fail(MsgCode.FA017.get());
        }
        String fileName = "license.lic";

        String filePath = FilePathUtil.getFilePath(type.toLowerCase());
        //上传文件
        UploadUtil.uploadFile(configValueUtil.getFileType(), type, fileName, file, filePath);
        log.debug("===========上传授权文件成功，开始安装===========");
        boolean install = licenseCheckListener.install();
        if(!install){
            return ActionResult.fail("不是合法的授权文件，请重试！");
        }else{
            return this.getInfo();
        }
    }

}
