package com.bringspring.common.model.login;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 系统的核心基础信息
 *
 * @author RKKJ开发平台组
 * @version V1.2.191207
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
public class BaseSystemInfo {
    /**
     * 单一登录：1-后登录踢出先登录、2-同时登陆
     */
    private Integer singleLogin;

    /**
     * 验证码位数
     */
    private String defaultPassword;
    /**
     * 密码错误次数
     */
    private Integer passwordErrorsNumber;
    /**
     * 错误策略  1--账号锁定  2--延时登录
     */
    private Integer lockType;
    /**
     * 延时登录时间
     */
    private Integer lockTime;
    /**
     * 是否开启验证码
     */
    private Integer enableVerificationCode;
    /**
     * 验证码位数
     */
    private Integer verificationCodeNumber;


    /**
     * 超时登出时间小时
     */
    private String tokenTimeout="900";
    /**
     * 上次登录时间提示开关
     */
    private Integer lastLoginTimeSwitch = 0;
    /**
     * 公司电话
     */
    private String companyTelePhone;
    /**
     * appid
     */
    private String wxGzhAppId;
    /**
     * 公司地址
     */
    private String companyAddress;

    private String wxGzhAppSecret;


    private String isLog;

    private String emailSmtpPort;

    private String emailPop3Host;

    private String emailSenderName;
    /**
     * 公司邮箱
     */
    private String companyEmail;

    private String sysName;
    /**
     * 版权信息
     */
    private String copyright;


    private String lastLoginTime;

    private String emailAccount;


    private String whitelistSwitch;

    private String pageSize;
    /**
     * 系统pc端地址
     */
    private String sysComputerUrl;
    /**
     * 系统手机端地址
     */
    private String sysMobileUrl;
    /**
     * 系统描述
     */
    private String sysDescription;

    private String emailPassword;
    /**
     * 公司法人
     */
    private String companyContacts;
    /**
     * 系统主题
     */
    private String sysTheme;


    private String whitelistIp;
    /**
     * 公司简称
     */
    private String companyCode;

    private String emailSsl;

    private String emailSmtpHost;

    private String registerKey;

    private String wxGzhToken;

    /**
     * 系统版本
     */
    private String sysVersion;

    private String emailPop3Port;
    /**
     * 公司名称
     */
    private String companyName;

    private String wxGzhUrl;

    private String qyhCorpSecret;
    private String qyhAgentId;
    private String qyhAgentSecret;
    private String qyhJoinTitle;
    private String qyhJoinUrl;

    private String qyhCorpId;
    /**
     * 企业微信-是否同步组织(包含：公司、部门)
     */
    private Integer qyhIsSynOrg;

    /**
     * 企业微信-是否同步用户
     */
    private Integer qyhIsSynUser;


    /**
     * 钉钉同步公司-部门-用户的应用AppKey
     */
    private String dingSynAppKey;

    /**
     * 钉钉同步公司-部门-用户的应用AppSecret
     */
    private String dingSynAppSecret;

    /**
     * 钉钉-是否同步组织(包含：公司、部门)
     */
    private Integer dingSynIsSynOrg;

    /**
     * 钉钉-是否同步用户
     */
    private Integer dingSynIsSynUser;

    // 图标----
    private String loginIcon;

    private String logoIcon;

    private String appIcon;

    private String navigationIcon;

    private String orgParent;

    private String clientId;

    private String clientSecrent;


    private String dingCom;


    @Schema(description = "密码定期更新开关")
    private Integer passwordIsUpdatedRegularly;

    @Schema(description = "更新周期")
    private Integer updateCycle;

    @Schema(description = "提前N天提醒更新")
    private Integer updateInAdvance;

    @Schema(description = "密码强度限制开关")
    private Integer passwordStrengthLimit;

    @Schema(description = "最小长度开关")
    private Integer passwordLengthMin;

    @Schema(description = "密码最小长度限制")
    private Integer passwordLengthMinNumber;

    @Schema(description = "是否包含数字")
    private Integer containsNumbers;

    @Schema(description = "是否包含小写字母")
    private Integer includeLowercaseLetters;

    @Schema(description = "是否包含大写字母")
    private Integer includeUppercaseLetters;

    @Schema(description = "是否包含字符")
    private Integer containsCharacters;

    @Schema(description = "是否禁用旧密码开关")
    private Integer disableOldPassword;

    @Schema(description = "禁用旧密码个数")
    private Integer disableTheNumberOfOldPasswords;

    @Schema(description = "初始密码强制修改开关")
    private Integer mandatoryModificationOfInitialPassword;

    /** --------------- 安全设置 --------------- **/

    /**
     * 审批链接时效性
     */
    private String linkTime;

    /**
     * 链接点击次数
     */
    private Integer isClick;

    /**
     * 链接失效次数
     */
    private Integer unClickNum;


    @Schema(description = "窗口标题")
    private String title;

    @Schema(description = "用户密码")
    private String newUserDefaultPassword;

    /*以下日程相关属性添加*/
    @Schema(description = "默认视图")
    private String defaultView;
    @Schema(description = "显示农历")
    private Boolean showLunarCalendar;
    @Schema(description = "周第一天")
    private Integer firstDay;
    @Schema(description = "默认时长")
    private Integer duration;
    @Schema(description = "流程签收")
    private Integer flowSign = 0;
    @Schema(description = "流程办理")
    private Integer flowTodo = 0;
    /**
     * 1:无范围限制  2:同一部门  3:同一岗位  6:同一公司
     */
    @Schema(description = "委托范围")
    private Integer delegateScope = 1;
    @Schema(description = "委托确认")
    private Integer delegateAck = 0;
    @Schema(description = "代理范围")
    private Integer proxyScope = 1;
    @Schema(description = "代理确认")
    private Integer proxyAck = 0;
    @Schema(description = "加签层级")
    private Integer addSignLevel = 1;

    /**
     * 模块设置
     * 组织岗位层级1-9
     */
    @Schema(description = "组织层级设置")
    private Integer orgLevel = 9;
    @Schema(description = "岗位层级设置")
    private Integer positionLevel = 9;
    @Schema(description = "组织层级不验证（1-开启不验证，其他验证）")
    private Integer orgNotCheck = 1;
    @Schema(description = "系统岗位名称")
    private String sysPositionName = "默认岗位";
}
