package com.bringspring.common.model.login;

import lombok.Data;

import java.util.Date;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:14
 */
@Data
public class ModuleModel {
    private String id;
    private String parentId;
    private String fullName;
    private String icon;

    /**
     * 菜单类型 0-系统、1-目录、2-页面、3-菜单、4-字典、5- reports、6-大屏、7-外链、8-门户、
     */
    private int type;
    private String urlAddress;
    private String linkTarget;
    private String category;
    private String description;
    private Long sortCode = 999999L;
    private String enCode;
    private String propertyJson;
    /**
     * 有效标志
     */
    private Integer enabledMark = 0;

    private String systemId;
    private Long creatorTime;
    private Date creatorTimes;

    public Long getCreatorTime() {
        if (this.creatorTimes != null && this.creatorTime == null) {
            return this.getCreatorTimes().getTime();
        } else if (this.creatorTime != null) {
            return this.creatorTime;
        }
        return 0L;
    }

    public void setCreatorTimes(Date creatorTimes) {
        this.creatorTimes = creatorTimes;
        if (creatorTimes != null && this.creatorTime == null) {
            this.creatorTime = creatorTimes.getTime();
        }
    }

    public void setCreatorTime(Long creatorTime) {
        this.creatorTime = creatorTime;
        if (creatorTime != null && this.creatorTimes == null) {
            this.creatorTimes = new Date(creatorTime);
        }
    }
}
