package com.bringspring.common.properties;

import lombok.Data;
import java.lang.reflect.Method;

/**
 * 注解路径信息封装类
 */
@Data
public class NotCheckLoginPathInfo {
    /**
     * 完整的URL路径
     */
    private String fullPath;

    /**
     * Controller类名
     */
    private String controllerClass;

    /**
     * 方法名
     */
    private String methodName;

    /**
     * HTTP方法类型
     */
    private String httpMethod;

    /**
     * 方法对象（可选，用于反射调用）
     */
    private Method method;

    /**
     * 方法签名
     */
    private String methodSignature;

    /**
     * 构造方法
     */
    public NotCheckLoginPathInfo(String fullPath, String controllerClass,
                                 String methodName, String httpMethod, Method method) {
        this.fullPath = fullPath;
        this.controllerClass = controllerClass;
        this.methodName = methodName;
        this.httpMethod = httpMethod;
        this.method = method;
        this.methodSignature = controllerClass + "#" + methodName;
    }

    @Override
    public String toString() {
        return String.format("%-8s %-60s [%s]",
                httpMethod, fullPath, methodSignature);
    }
}
