package com.bringspring.common.util.context;


import com.bringspring.common.constant.JnpfConst;
import com.bringspring.common.util.ServletUtil;
import com.bringspring.common.util.StringUtils;

import java.net.URLDecoder;
import java.util.Objects;

/**
 * @author JNPF开发平台组
 * @version V3.5.0
 * @copyright 引迈信息技术有限公司
 * @date 2023/9/11 00:00
 */
public class RequestContext {

    public static boolean isVue3() {
        //2, 3
        return Objects.equals(ServletUtil.getHeader("vue-version"), "3");
    }

    public static boolean isOrignPc() {
        //pc, app
        return !Objects.equals(ServletUtil.getHeader("jnpf-origin"), "app");
    }

    /**
     * 获取请求头参数，应用id
     *
     * @return
     */
    public static String getAppCode() {
        //主系统为空
        String appCode = ServletUtil.getHeader("app-code");
        if (StringUtils.isEmpty(appCode)) appCode = JnpfConst.MAIN_SYSTEM_CODE;
        try {
            appCode = URLDecoder.decode(appCode, "UTF-8");
        } catch (Exception e) {
        }
        return appCode;
    }
}
