/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.auth.config;

import cn.dev33.satoken.config.SaTokenConfig;
import com.bringspring.common.auth.util.TenantProvider;
import com.bringspring.common.model.login.BaseSystemInfo;
import java.util.Optional;

public class JnpfTokenConfig
extends SaTokenConfig {
    public long getTimeout() {
        BaseSystemInfo baseSystemInfo = this.getSycConfig();
        if (baseSystemInfo == null) {
            return super.getTimeout();
        }
        return Long.parseLong(this.getSycConfig().getTokenTimeout()) * 60L;
    }

    public Boolean getIsConcurrent() {
        BaseSystemInfo baseSystemInfo = this.getSycConfig();
        if (baseSystemInfo == null) {
            return super.getIsConcurrent();
        }
        return Optional.ofNullable(this.getSycConfig().getSingleLogin()).orElse(1) == 2;
    }

    public String getJwtSecretKey() {
        String secrekey = super.getJwtSecretKey();
        if (secrekey == null) {
            return "WviMjFNC72VKwGqm5LPoheQo5XN9iN4d";
        }
        return secrekey;
    }

    public String getCurrDomain() {
        return super.getCurrDomain();
    }

    public String getTokenPrefix() {
        return "bearer";
    }

    public Boolean getTokenSessionCheckLogin() {
        return false;
    }

    public Boolean getIsPrint() {
        return false;
    }

    public Boolean getIsShare() {
        return false;
    }

    public String getTokenName() {
        return "Authorization";
    }

    public Boolean getIsReadCookie() {
        return false;
    }

    public Boolean getIsReadBody() {
        return false;
    }

    public Boolean getIsReadHeader() {
        return true;
    }

    public int getMaxLoginCount() {
        return -1;
    }

    private BaseSystemInfo getSycConfig() {
        return TenantProvider.getBaseSystemInfo();
    }
}

