/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.auth.util;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.temp.SaTempUtil;
import org.springframework.stereotype.Component;

@Component
public class TicketUtil {
    public static String createTicket(Object value, long timeout) {
        return SaTempUtil.createToken((Object)value, (long)timeout);
    }

    public static <T> T parseTicket(String ticket) {
        return (T)SaTempUtil.parseToken((String)ticket);
    }

    public static void deleteTicket(String ticket) {
        SaTempUtil.deleteToken((String)ticket);
    }

    public static void updateTicket(String ticket, Object value, Long timeout) {
        Object obj = TicketUtil.parseTicket(ticket);
        if (obj == null) {
            return;
        }
        String key = TicketUtil.getTicketKey(ticket);
        if (timeout != null) {
            SaManager.getSaTokenDao().setObject(key, value, timeout.longValue());
        } else {
            SaManager.getSaTokenDao().updateObject(key, value);
        }
    }

    private static String getTicketKey(String ticket) {
        return SaManager.getSaTempTemplate().splicingTempTokenSaveKey(ticket);
    }
}

