/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.db;

import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.limit.DateTimeLimit;
import com.bringspring.common.database.datatype.limit.DecimalLimit;
import com.bringspring.common.database.datatype.limit.FloatLimit;
import com.bringspring.common.database.datatype.limit.IntegerLimit;
import com.bringspring.common.database.datatype.limit.StringLimit;
import lombok.Generated;

public enum DtDorisEnum implements DtInterface
{
    TINY_INT("tinyint", new IntegerLimit().fixedPrecision(3)),
    BOOLEAN("boolean", new IntegerLimit().fixedPrecision(null)),
    SMALL_INT("smallint", new IntegerLimit().fixedPrecision(5)),
    INT("int", new IntegerLimit().fixedPrecision(10)),
    BIGINT("bigint", new IntegerLimit().fixedPrecision(19)),
    LARGE_INT("largeint", new IntegerLimit().fixedPrecision(null)),
    CHAR("char", new StringLimit(true).charLength(255L, 50L)),
    VARCHAR("varchar", new StringLimit(true).charLength(16170L, 50L)),
    STRING("string", new StringLimit()),
    FLOAT("float", new FloatLimit(true).precision(35, 18).scale(30, 3)),
    DOUBLE("double", new FloatLimit(true).fixedPrecision(35).fixedScale(30)),
    DECIMAL("decimal", new DecimalLimit(true).precision(27, 18).scale(30, 3)),
    DATE("date", new DateTimeLimit()),
    DATE_TIME("datetime", new DateTimeLimit()),
    BITMAP("BITMAP", new StringLimit()),
    HLL("HLL", new StringLimit());

    private final String dataType;
    private final DtLimitBase dtLimit;

    @Override
    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Override
    @Generated
    public DtLimitBase getDtLimit() {
        return this.dtLimit;
    }

    @Generated
    private DtDorisEnum(String dataType, DtLimitBase dtLimit) {
        this.dataType = dataType;
        this.dtLimit = dtLimit;
    }
}

