/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.limit;

import com.bringspring.common.database.datatype.db.DtMySQLEnum;
import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.model.DtModel;
import com.bringspring.common.database.datatype.model.DtModelDTO;
import com.bringspring.common.database.datatype.sync.util.DtSyncUtil;
import lombok.Generated;

public class IntegerLimit
extends DtLimitBase {
    public static final String CATEGORY = "type-Integer";
    public static final String JAVA_TYPE = "int";

    @Override
    public String initDtCategory() {
        return CATEGORY;
    }

    @Override
    public DtModel convert(DtModelDTO viewDtModel) {
        DtInterface targetDtEnum = viewDtModel.getConvertTargetDtEnum();
        DtModel toModel = new DtModel(targetDtEnum);
        if (targetDtEnum.getDtCategory().equals("type-Number")) {
            try {
                DtMySQLEnum dtEnum = (DtMySQLEnum)DtSyncUtil.getToFixCovert(targetDtEnum, "MySQL");
                switch (dtEnum) {
                    case TINY_INT: {
                        toModel.setNumPrecision(3);
                        break;
                    }
                    case SMALL_INT: {
                        toModel.setNumPrecision(5);
                        break;
                    }
                    case MEDIUM_INT: {
                        toModel.setNumPrecision(7);
                        break;
                    }
                    case INT: {
                        toModel.setNumPrecision(10);
                        break;
                    }
                    case BIGINT: {
                        toModel.setNumPrecision(19);
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.isModifyFlag.booleanValue()) {
            toModel.setFormatLengthStr("");
        }
        return toModel;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerLimit)) {
            return false;
        }
        IntegerLimit other = (IntegerLimit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntegerLimit;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IntegerLimit()";
    }

    @Generated
    public IntegerLimit() {
    }
}

