/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.limit.util;

import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.limit.base.DtLimitModel;
import com.bringspring.common.database.datatype.model.DtModel;
import com.bringspring.common.database.datatype.model.DtModelDTO;

public class DtLimitUtil {
    public static DtModel convertNumeric(DtModelDTO dto) {
        DtInterface toDtEnum = dto.getConvertTargetDtEnum();
        DtModel toModel = new DtModel(toDtEnum);
        DtLimitModel numPrecisionLm = toDtEnum.getNumPrecisionLm();
        DtLimitModel numScaleLm = toDtEnum.getNumScaleLm();
        Integer numPrecision = dto.getNumPrecision();
        Integer numScale = dto.getNumScale();
        if (toDtEnum.getIsModifyFlag().booleanValue()) {
            switch (dto.getConvertType()) {
                case "DB_VAL": {
                    break;
                }
                case "FIX_VAL": {
                    numPrecision = (Integer)numPrecisionLm.getFixed();
                    numScale = (Integer)numScaleLm.getFixed();
                    break;
                }
                case "VIEW_VAL": {
                    numPrecision = DtLimitUtil.convertNum(numPrecision, (Integer)numPrecisionLm.getMin(), (Integer)numPrecisionLm.getMax(), (Integer)numPrecisionLm.getDefaults());
                    numScale = DtLimitUtil.convertNum(numScale, (Integer)numScaleLm.getMin(), (Integer)numScaleLm.getMax(), (Integer)numScaleLm.getDefaults());
                    break;
                }
            }
            toModel.setNumPrecision(numPrecision);
            toModel.setNumScale(numScale);
            toModel.formatNumLength(numPrecision, numScale);
        }
        return toModel;
    }

    public static Long convertCharacter(Long inputVarLength, String convertType, DtLimitModel varLengthLm) {
        Long outVarLength = null;
        switch (convertType) {
            case "DB_VAL": {
                outVarLength = inputVarLength;
                break;
            }
            case "FIX_VAL": {
                outVarLength = (Long)varLengthLm.getFixed();
                break;
            }
            case "VIEW_VAL": {
                outVarLength = DtLimitUtil.convertLongNum(inputVarLength, (Long)varLengthLm.getMax(), (Long)varLengthLm.getDefaults());
                break;
            }
        }
        return outVarLength;
    }

    public static void getNumericLength(DtModel model) {
        model.setFormatLengthStr(model.getNumPrecision() + "," + model.getNumScale());
    }

    private static Integer convertNum(Integer originNum, Integer toMin, Integer toMax, Integer defaultNum) {
        Integer n = originNum = originNum == null || originNum < toMin ? defaultNum : originNum;
        if (originNum >= toMin && toMax >= originNum) {
            return originNum;
        }
        if (originNum > toMax) {
            return toMax;
        }
        return toMin;
    }

    private static Long convertLongNum(Long originNum, Long toMax, Long defaultNum) {
        Long l = originNum = originNum == null || originNum < 1L ? defaultNum : originNum;
        if (originNum <= toMax) {
            return originNum;
        }
        return toMax;
    }
}

