/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.enums;

import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.source.impl.DbPostgre;
import lombok.Generated;

public enum DbAliasEnum {
    TABLE_SIZE("TABLE_SIZE"),
    TABLE_NAME("TABLE_NAME"),
    TABLE_COMMENT("TABLE_COMMENT"),
    TABLE_TYPE("TABLE_TYPE"),
    TABLE_SUM("TABLE_SUM"),
    FIELD("FIELD"),
    FIELD_COMMENT("FIELD_COMMENT"),
    DEFAULT_VALUE("DEFAULT_VALUE"),
    AUTO_INCREMENT("AUTO_INCREMENT"),
    COLUMN_DEFAULT("COLUMN_DEFAULT"),
    IS_IDENTITY("IS_IDENTITY"),
    ALLOW_NULL("ALLOW_NULL"){

        @Override
        public Integer isTrue() {
            return 1;
        }

        @Override
        public Integer isFalse() {
            return 0;
        }
    }
    ,
    PRIMARY_KEY("PRIMARY_KEY"){

        @Override
        public Integer isTrue() {
            return 1;
        }

        @Override
        public Integer isFalse() {
            return 0;
        }
    }
    ,
    DATA_TYPE("DATA_TYPE"),
    CHAR_LENGTH("CHAR_LENGTH"),
    NUM_PRECISION("NUM_PRECISION"),
    NUM_SCALE("NUM_SCALE"),
    TOTAL_RECORD("totalRecord"),
    TOTAL("total"),
    AUTO_TRIGGER("AUTO_TRIGGER");

    private final String alias;

    public Integer isTrue() {
        return null;
    }

    public Integer isFalse() {
        return null;
    }

    public String AS() {
        return this.alias;
    }

    public String asByDb(DbBase db) {
        if (DbPostgre.class.equals(db.getClass())) {
            return this.alias.toLowerCase();
        }
        if (DbOracle.class.equals(db.getClass())) {
            return this.alias.toUpperCase();
        }
        return this.alias;
    }

    public static String getAsByDb(DbBase db, String keyWord) {
        if (DbPostgre.class.equals(db.getClass())) {
            return keyWord.toLowerCase();
        }
        if (DbOracle.class.equals(db.getClass())) {
            return keyWord.toUpperCase();
        }
        return keyWord;
    }

    public String getAlias(String dbEncode) {
        return DbAliasEnum.getAlias(dbEncode, this.alias);
    }

    public static String getAlias(String dbEncode, String keyWord) {
        if ("PostgreSQL".equals(dbEncode)) {
            return keyWord.toLowerCase();
        }
        if ("Oracle".equals(dbEncode)) {
            return keyWord.toUpperCase();
        }
        return keyWord;
    }

    @Generated
    private DbAliasEnum(String alias) {
        this.alias = alias;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }
}

