/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.enums;

import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.enums.ParamEnum;
import com.bringspring.common.database.sql.enums.base.SqlFrameBase;
import com.bringspring.common.database.sql.model.DbStruct;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public enum SqlOracleEnum implements SqlFrameBase
{
    FIELDS("SELECT \n\tA.COLUMN_NAME AS " + DbAliasEnum.FIELD.getAlias() + ",\n\tA.DATA_TYPE AS " + DbAliasEnum.DATA_TYPE.getAlias() + ",\n\tA.DATA_LENGTH AS " + DbAliasEnum.CHAR_LENGTH.getAlias() + ",\n\tA.DATA_PRECISION AS " + DbAliasEnum.NUM_PRECISION.getAlias() + ",\n\tA.DATA_SCALE AS " + DbAliasEnum.NUM_SCALE.getAlias() + ",\n\tCASE WHEN E.CONSTRAINT_TYPE IS NOT NULL THEN '1' ELSE '0' END AS " + DbAliasEnum.PRIMARY_KEY.getAlias() + ",\n\tCASE A.NULLABLE WHEN 'N' THEN '0' ELSE '1' END AS " + DbAliasEnum.ALLOW_NULL.getAlias() + ",\n\t(SELECT COUNT(*) FROM ALL_TRIGGERS WHERE TABLE_NAME = A.TABLE_NAME AND TABLE_OWNER = A.OWNER AND INSTR(TRIGGER_NAME, 'AUTO_') >0) AS " + DbAliasEnum.AUTO_TRIGGER.getAlias() + ",\n\tB.COMMENTS AS " + DbAliasEnum.FIELD_COMMENT.getAlias() + "\nFROM \n\tALL_TAB_COLUMNS A -- \u8868&\u5b57\u6bb5 OWNER\u3001TABLE_NAME\u3001COLUMN_NAME_\t\nLEFT JOIN \n\tALL_COL_COMMENTS B -- \u5b57\u6bb5\u6ce8\u91ca TABLE_NAME\u3001COLUMN_NAME\nON \n\tA.OWNER = B.OWNER AND A.TABLE_NAME = B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME \nLEFT JOIN \n\t(SELECT \n\t\t\tC.OWNER, C.TABLE_NAME, C.COLUMN_NAME, D.CONSTRAINT_TYPE  \n\t\tFROM \n\t\t\tALL_CONS_COLUMNS C, ALL_CONSTRAINTS D \n\t\tWHERE \n\t\t\tC.CONSTRAINT_NAME = D.CONSTRAINT_NAME AND D.CONSTRAINT_TYPE = 'P'\n\t) E\nON\n\tA.OWNER = E.OWNER AND A.TABLE_NAME = E.TABLE_NAME AND A.COLUMN_NAME = E.COLUMN_NAME \nWHERE\n  A.OWNER = " + ParamEnum.DB_NAME.getParamSign() + "\n\tAND A.TABLE_NAME = " + ParamEnum.TABLE.getParamSign()){

        @Override
        public void setStructParams(String table, DbStruct dbStruct, List<String> list) {
            list.add(dbStruct.getOracleDbSchema());
            list.add(table);
        }
    }
    ,
    TABLES("SELECT atcs.table_name " + DbAliasEnum.TABLE_NAME.getAlias() + ", atcs.comments " + DbAliasEnum.TABLE_COMMENT.getAlias() + ", ats.num_rows " + DbAliasEnum.TABLE_SUM.getAlias() + "\nFROM all_tab_comments atcs,all_tables ats WHERE atcs.table_name = ats.table_name AND ats.owner = atcs.owner AND ats.owner = " + ParamEnum.DB_NAME.getParamSign()){

        @Override
        public void setStructParams(String table, DbStruct dbStruct, List<String> list) {
            list.add(dbStruct.getOracleDbSchema());
        }
    }
    ,
    TABLESANDVIEW("SELECT\n\tatcs.table_name " + DbAliasEnum.TABLE_NAME.getAlias() + ",\n\tatcs.comments " + DbAliasEnum.TABLE_COMMENT.getAlias() + ",\n\tatcs.table_type " + DbAliasEnum.TABLE_TYPE.getAlias() + " \nFROM\n\tall_tab_comments atcs\n\tLEFT JOIN all_views alv ON alv.owner = atcs.owner \nWHERE\n\tatcs.owner = " + ParamEnum.DB_NAME.getParamSign()){

        @Override
        public void setStructParams(String table, DbStruct dbStruct, List<String> list) {
            list.add(dbStruct.getOracleDbSchema());
        }
    }
    ,
    TABLE(SqlOracleEnum.TABLES.sqlFrame + " AND ats.TABLE_NAME = " + ParamEnum.TABLE.getParamSign()){

        @Override
        public void setStructParams(String table, DbStruct dbStruct, List<String> list) {
            list.add(dbStruct.getOracleDbSchema());
            list.add(table);
        }
    }
    ,
    EXISTS_TABLE("SELECT COUNT(*) AS TOTAL FROM ALL_TABLES WHERE OWNER =  UPPER(" + ParamEnum.DB_NAME.getParamSign() + ") AND  TABLE_NAME = UPPER(" + ParamEnum.TABLE.getParamSign() + ")"){

        @Override
        public void setStructParams(String table, DbStruct dbStruct, List<String> list) {
            list.add(dbStruct.getOracleDbSchema());
            list.add(table);
        }
    }
    ,
    CREATE_TABLE("<CREATE> <TABLE> {table} <(>\n\u3010{column} {dataType} [[NOT] [NULL]] [<DEFAULT> {defaultValue}] \u3011\n{primarykeys}\n<)>"){

        @Override
        public String createIndex() {
            String model = "CREATE UNIQUE INDEX {indexName} ON {table}(\u3010column\u3011)";
            return null;
        }
    }
    ,
    CREATE_AUTO_INCREMENT("CREATE SEQUENCE {table}_seq\nINCREMENT by 1\nSTART WITH 1\nNOMAXVALUE\nNOCYCLE\nNOCACHE"),
    CREATE_AUTO_INCREMENT_TRIGGER("CREATE OR REPLACE TRIGGER AUTO_{table}_tg\nBEFORE INSERT ON {table}\nFOR EACH ROW\nBEGIN\n\tSELECT {table}_seq.NEXTVAL INTO :new.{autoInc_field} FROM dual;\nEND;"),
    DROP_SEQ("DROP sequence {seqName}"),
    DROP_TRIGGER("DROP trigger {triggerName}"),
    CREATE("CREATE TABLE \u300aschema\u300b.{table}(\n\u3010  1:(PRIMARY KEY ({primaryColumn}))|2:({column} {dataType} [[NOT] [NULL]] [DEFAULT {defaultValue}]),\n\u3011)"),
    DROP_TABLE("DROP TABLE {table}"),
    COMMENT_TABLE("COMMENT ON TABLE \u300aschema\u300b.{table} IS '{comment}'"),
    COMMENT_COLUMN("COMMENT ON COLUMN \u300aschema\u300b.{table}.{column} IS '{comment}'"),
    DROP_COLUMN("ALTER TABLE \u300aschema\u300b.{table} DROP COLUMN {column}"),
    ADD_COLUMN("ALTER TABLE \u300aschema\u300b.{table} ADD {column} {dataType}"),
    MODIFY_TYPE("ALTER TABLE \u300aschema\u300b.{table} ALTER COLUMN {column} TYPE {dataType}"),
    ALTER_TABLE("ALTER TABLE \u300aschema\u300b.{oldTable} RENAME TO {newTable}"),
    ORDER_PAGE("SELECT * FROM (SELECT JNPF_TEMP.*, ROWNUM JNPF_RowNo FROM ({selectSql}) JNPF_TEMP ORDER BY {orderColumn} [DESC]) JNPF_TAB WHERE JNPF_TAB.JNPF_RowNo BETWEEN {beginIndex} AND {endIndex}"),
    DB_TIME_SQL("select to_char(sysdate,'yyyy-mm-dd hh24:mi:ss') as TIME from dual"),
    INSERT("INSERT INTO \u300aschema\u300b.{table} (\u3010{column},\u3011) VALUES (\u3010{value},\u3011)"),
    CLOB_INSERT("DECLARE\n\tclobVal {table}.{column}%TYPE;\nBEGIN\t\n\tclobVal := '{value}';\nINSERT INTO {table} (\u3010{clobColumn},{column},\u3011) VALUES (\u3010{clobVal},{value},\u3011);\nEND"),
    CLOB_UPDATE("DECLARE \n-- \u6b64\u8868\u4e3a\uff1a{table}\n\tv_context NCLOB;\nBEGIN\n\tDBMS_LOB.CREATETEMPORARY(v_context,TRUE);\n\t\u3010DBMS_LOB.APPEND(v_context, '{context}');\u3011\n\tUPDATE {table} SET {column} = v_context WHERE {key} = '{value}';\nEND"){

        @Override
        public String getFastSql(List<String> values) {
            String sql = this.getSqlFrame();
            List<String> keys = Arrays.asList("{table}", "{column}", "\t\u3010DBMS_LOB.APPEND(v_context, '{context}');\u3011\n", "{key}", "{value}");
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) == null) continue;
                sql = sql.replace(keys.get(i), values.get(i));
            }
            return sql;
        }
    }
    ,
    CLOB_APPEND("DBMS_LOB.APPEND(v_context, '{context}')"),
    BLOB_UPDATE("DECLARE \n-- \u6b64\u8868\u4e3a\uff1a{table}\n\tv_context BLOB;\nBEGIN\n\tDBMS_LOB.CREATETEMPORARY(v_context,TRUE);\n\t\u3010DBMS_LOB.APPEND(v_context, HEXTORAW('{context}'))\u3011\n\tUPDATE {table} SET {column} = v_context WHERE {key} = '{value}';\nEND"){

        @Override
        public String getFastSql(List<String> values) {
            String sql = this.getSqlFrame();
            List<String> keys = Arrays.asList("{table}", "{column}", "\t\u3010DBMS_LOB.APPEND(v_context, HEXTORAW('{context}'))\u3011\n", "{key}", "{value}");
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) == null) continue;
                sql = sql.replace(keys.get(i), values.get(i));
            }
            return sql;
        }
    }
    ,
    BLOB_APPEND("DBMS_LOB.APPEND(v_context, HEXTORAW('{context}'))"),
    TO_TIME("TO_DATE('{datetime}','YYYY-MM-DD HH24:MI:SS')"),
    SELECT_TABLESPACE("SELECT TABLESPACE_NAME,FILE_ID,FILE_NAME,round(bytes/(1024*1024),0) total_space FROM DBA_DATA_FILES ORDER BY TABLESPACE_NAME"),
    CREATE_TEMP_TABLESPACE("CREATE TEMPORARY TABLESPACE UQSM_TEMP TEMPFILE '/{path}/{tempTablespaceName}.dbf' size 8000m autoextend on next 50m maxsize unlimited extent management local;"),
    CREATE_TABLESPACE("\nCREATE TABLESPACE UQSM_DATA LOGGING DATAFILE '/{path}/{tempTablespaceName}.dbf' SIZE 8000m autoextendon next 50M maxsize unlimited extent management local;\n"),
    CREATE_USER("CREATE USER {user} IDENTIFIED BY {password} DEFAULT TABLESPACE {tablespace} TEMPORARY TABLESPACE {tempTablespace}"),
    DROP_USER("DROP USER {user}"),
    GRANT_ROLE("GRANT connect,RESOURCE,dba to {user};"),
    ALTER_USER_PASSWORD("ALTER USER {user} IDENTIFIED BY {password}");

    private final String sqlFrame;
    private final String dbEncode = "Oracle";

    public String getFastSql(List<String> values) {
        return this.getSqlFrame();
    }

    @Override
    @Generated
    public String getSqlFrame() {
        return this.sqlFrame;
    }

    @Override
    @Generated
    public String getDbEncode() {
        return this.dbEncode;
    }

    @Generated
    private SqlOracleEnum(String sqlFrame) {
        this.sqlFrame = sqlFrame;
    }
}

