/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.impl;

import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.enums.ParamEnum;
import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbMySQL;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.sql.append.create.CreateSql;
import com.bringspring.common.database.sql.append.create.CreateSqlDTO;
import com.bringspring.common.database.sql.append.insert.InsertSql;
import com.bringspring.common.database.sql.append.insert.InsertSqlDTO;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.util.HtmlUtils;

public class SqlMySQL
extends SqlBase {
    private final String dbTimeSql = "SELECT DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%s') as TIME";

    @Override
    protected void init() {
        String fieldListSql = "SELECT COLUMN_NAME FIELD_NAME,data_type DATATYPE,CHARACTER_MAXIMUM_LENGTH DATA_LENGTH, COLUMN_TYPE COLUMNTYPE,NUMERIC_PRECISION AS `PRECISION`,NUMERIC_SCALE AS DECIMALS, IF ( IS_NULLABLE = 'YES', '1', '0' ) ALLOW_NULL, COLUMN_COMMENT FIELD_COMMENT,IF ( COLUMN_KEY = 'PRI', '1', '0' ) PRIMARY_KEY, column_default DEFAULTS,CONCAT(upper(COLUMN_NAME),'(',COLUMN_COMMENT,')') as 'DESCRIPTION' FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = " + ParamEnum.TABLE.getParamSign() + " AND TABLE_SCHEMA= " + ParamEnum.DB_SCHEMA.getParamSign() + ";";
        String tableListSql = "SELECT table_name TABLE_NAME,table_rows TABLE_SUM, data_length TABLE_SIZE, table_comment TABLE_COMMENT, CONCAT(table_name,'(',table_comment,')') as 'DESCRIPTION' FROM information_schema.TABLES WHERE TABLE_SCHEMA = " + ParamEnum.DB_NAME.getParamSign() + ";";
        String existsTableSql = "SELECT table_name TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA = " + ParamEnum.DB_NAME.getParamSign() + " and table_name = " + ParamEnum.TABLE.getParamSign() + ";";
        this.setInstance(fieldListSql, tableListSql, existsTableSql, "{table}:{dbName}", "{dbName}:", "{dbName}:{table}");
    }

    @Override
    public String batchInsertSql(List<List<DbFieldMod>> dataList, String table) throws DataException {
        DbBase dbBase = DbTypeUtil.getDriver("MySQL");
        InsertSqlDTO iInsertSqlDTO = new InsertSqlDTO(dbBase, table, dataList, ",");
        String sql = InsertSql.batch(iInsertSqlDTO);
        return sql.substring(0, sql.length() - 1) + ";";
    }

    @Override
    public String[] getPageSql(String sql, String sortType, Integer currentPage, Integer pageSize) throws DataException {
        DbBase dbBase = DbTypeUtil.getDriver("MySQL");
        int startIndex = currentPage - 1;
        Object sortSql = StringUtils.isEmpty(sortType) ? "" : " ORDER BY " + sortType;
        String dataListSql = sql + (String)sortSql + " LIMIT " + startIndex * pageSize + "," + pageSize + ";";
        String totalSql = "SELECT COUNT(*) " + DbAliasEnum.TOTAL_RECORD.asByDb(dbBase) + " FROM (" + sql + ") jsbos_tab;";
        return new String[]{dataListSql, totalSql};
    }

    private String getTotalSql(String sql) {
        int selectStar = sql.indexOf("SELECT");
        int fromEnd = sql.indexOf("FROM");
        return sql.substring(0, selectStar + 6) + " COUNT(*) AS totalRecord " + sql.substring(fromEnd);
    }

    @Override
    public PreparedStatementDTO getTableCommentPSD(CreateSqlDTO createSqlDTO) {
        String table = HtmlUtils.htmlEscape((String)String.valueOf(createSqlDTO.getNewTable()), (String)"UTF-8");
        String preparedSql = "ALTER TABLE " + table + " COMMENT= ?;";
        return new PreparedStatementDTO(null, preparedSql, createSqlDTO.getTableComment());
    }

    @Override
    public List<PreparedStatementDTO> getFieldCommentPSD(CreateSqlDTO createSqlDTO) {
        String table = HtmlUtils.htmlEscape((String)String.valueOf(createSqlDTO.getNewTable()), (String)"UTF-8");
        ArrayList<PreparedStatementDTO> listPSD = new ArrayList<PreparedStatementDTO>();
        String dataTypeFormat = "";
        for (DbTableFieldModel fieldModel : createSqlDTO.getFieldModels()) {
            try {
                dataTypeFormat = CreateSql.dataTypeFormat(fieldModel.getDataType(), fieldModel.getDataLength(), fieldModel.getPrimaryKey(), new DbMySQL());
            }
            catch (DataException e) {
                e.printStackTrace();
            }
            String column = HtmlUtils.htmlEscape((String)String.valueOf(fieldModel.getField()), (String)"UTF-8");
            String preparedSql = "ALTER TABLE " + table + " MODIFY COLUMN `" + column + "` " + dataTypeFormat + " COMMENT ?;";
            listPSD.add(new PreparedStatementDTO(null, preparedSql, fieldModel.getFieldName()));
        }
        return listPSD;
    }

    public static String getCreFieldComment(String tableComment) {
        return "COMMENT " + tableComment;
    }

    public static List<PreparedStatementDTO> getTabComment(String tableComment) {
        String sql = "\tCOMMENT\t'" + tableComment + "';";
        return new ArrayList<PreparedStatementDTO>();
    }
}

