/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.param.base;

import com.bringspring.common.database.model.dbfield.DbFieldModel;
import com.bringspring.common.database.model.dbfield.JdbcColumnModel;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.model.SqlPrintHandler;
import com.bringspring.common.database.sql.param.FormatSqlMySQL;
import com.bringspring.common.database.sql.param.FormatSqlOracle;
import com.bringspring.common.util.context.SpringContext;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import lombok.Generated;

public class FormatSql {
    private static SqlPrintHandler sqlPrintHandler = SpringContext.getBean(SqlPrintHandler.class);
    private String dbEncode;

    public static Object convertValue(JdbcColumnModel dbColumnModel, DbBase toDb) throws Exception {
        switch (toDb.getDbEncode()) {
            case "Oracle": 
            case "PostgreSQL": {
                return FormatSql.getPostgreValue(dbColumnModel);
            }
            case "MySQL": {
                return FormatSqlMySQL.getMysqlValue(dbColumnModel);
            }
        }
        return dbColumnModel.getValue();
    }

    public static Object getPostgreValue(JdbcColumnModel dbColumnModel) {
        return dbColumnModel.getValue();
    }

    public static String getFieldName(String fieldName, String dbEncode) {
        switch (dbEncode) {
            case "MySQL": {
                return "`" + fieldName + "`";
            }
            case "SQLServer": {
                return fieldName;
            }
            case "Oracle": 
            case "DM8": {
                return "\"" + fieldName.toUpperCase() + "\"";
            }
            case "PostgreSQL": {
                return "\"" + fieldName.toLowerCase() + "\"";
            }
        }
        return fieldName;
    }

    public static String formatValue(Object value, String dbEncode) {
        if (value == null) {
            return "Null";
        }
        if (value instanceof LocalDateTime || value instanceof Date) {
            Date date = value instanceof LocalDateTime ? Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant()) : (Date)value;
            Object dateInfo = "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date) + "'";
            dateInfo = FormatSqlOracle.dateTime(dbEncode, (String)dateInfo);
            return dateInfo;
        }
        if (value instanceof String) {
            String context = value.toString().replace("'", "''");
            return "'" + context + "'";
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        return value.toString();
    }

    public static String defaultCheck(DbFieldModel fieldModel, String dbEncode) {
        if (fieldModel.getDefaultValue() != null) {
            String defaultValue = "'" + fieldModel.getDefaultValue() + "'";
            if ("Oracle".equals(dbEncode)) {
                fieldModel.setNullSign("");
                if (fieldModel.getDataType().equalsIgnoreCase("DATETIME")) {
                    defaultValue = "to_date(" + defaultValue + ", 'yyyy-mm-dd hh24:mi:ss')";
                }
            }
            return "DEFAULT " + defaultValue;
        }
        return "";
    }

    @Generated
    public String getDbEncode() {
        return this.dbEncode;
    }

    @Generated
    public void setDbEncode(String dbEncode) {
        this.dbEncode = dbEncode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormatSql)) {
            return false;
        }
        FormatSql other = (FormatSql)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dbEncode = this.getDbEncode();
        String other$dbEncode = other.getDbEncode();
        return !(this$dbEncode == null ? other$dbEncode != null : !this$dbEncode.equals(other$dbEncode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FormatSql;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dbEncode = this.getDbEncode();
        result = result * 59 + ($dbEncode == null ? 43 : $dbEncode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FormatSql(dbEncode=" + this.getDbEncode() + ")";
    }

    @Generated
    public FormatSql(String dbEncode) {
        this.dbEncode = dbEncode;
    }
}

