/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.event.strategy;

import com.bringspring.common.event.strategy.ActionStrategy;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ActionMethodContext
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Map<String, ActionStrategy> methodMap = new HashMap<String, ActionStrategy>();

    public void afterPropertiesSet() throws Exception {
        this.applicationContext.getBeansOfType(ActionStrategy.class).values().stream().forEach(actionStrategy -> this.methodMap.put(actionStrategy.actionMethod(), (ActionStrategy)actionStrategy));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ActionStrategy getActionMethod(String actionMethod) {
        return this.methodMap.get(actionMethod);
    }
}

