/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.properties;

import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.properties.NotCheckLoginPathInfo;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Component
public class NotCheckLoginPathScanner
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotCheckLoginPathScanner.class);
    private ApplicationContext applicationContext;
    private final Map<String, NotCheckLoginPathInfo> notCheckLoginPaths = new ConcurrentHashMap<String, NotCheckLoginPathInfo>();
    private final Map<String, List<NotCheckLoginPathInfo>> controllerPaths = new ConcurrentHashMap<String, List<NotCheckLoginPathInfo>>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        log.info("\u5f00\u59cb\u626b\u63cf\u5e26\u6709@NotCheckLogin\u6ce8\u89e3\u7684Controller\u65b9\u6cd5...");
        this.scanNotCheckLoginPaths();
        log.info("\u626b\u63cf\u5b8c\u6210\uff0c\u5171\u627e\u5230 {} \u4e2a\u4e0d\u9700\u8981\u767b\u5f55\u68c0\u67e5\u7684\u63a5\u53e3", (Object)this.notCheckLoginPaths.size());
        this.printScanResult();
    }

    private void scanNotCheckLoginPaths() {
        Map controllerBeans = this.applicationContext.getBeansWithAnnotation(Controller.class);
        controllerBeans.putAll(this.applicationContext.getBeansWithAnnotation(RestController.class));
        for (Object controller : controllerBeans.values()) {
            Class<?> controllerClass = controller.getClass();
            Class<?> targetClass = this.getTargetClass(controllerClass);
            RequestMapping classRequestMapping = (RequestMapping)AnnotationUtils.findAnnotation(targetClass, RequestMapping.class);
            String classPath = "";
            if (classRequestMapping != null && classRequestMapping.value().length > 0) {
                classPath = this.normalizePath(classRequestMapping.value()[0]);
            }
            this.scanMethodsInClass(targetClass, classPath);
        }
    }

    private void scanMethodsInClass(Class<?> controllerClass, String classPath) {
        Method[] methods;
        for (Method method : methods = controllerClass.getDeclaredMethods()) {
            NotCheckLogin notCheckLogin = (NotCheckLogin)AnnotationUtils.findAnnotation((Method)method, NotCheckLogin.class);
            if (notCheckLogin == null) continue;
            RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            GetMapping getMapping = (GetMapping)AnnotationUtils.findAnnotation((Method)method, GetMapping.class);
            PostMapping postMapping = (PostMapping)AnnotationUtils.findAnnotation((Method)method, PostMapping.class);
            PutMapping putMapping = (PutMapping)AnnotationUtils.findAnnotation((Method)method, PutMapping.class);
            DeleteMapping deleteMapping = (DeleteMapping)AnnotationUtils.findAnnotation((Method)method, DeleteMapping.class);
            PatchMapping patchMapping = (PatchMapping)AnnotationUtils.findAnnotation((Method)method, PatchMapping.class);
            this.processMethodMapping(method, controllerClass, classPath, "GET", getMapping != null ? getMapping.value() : (requestMapping != null ? requestMapping.value() : new String[]{}));
            this.processMethodMapping(method, controllerClass, classPath, "POST", postMapping != null ? postMapping.value() : (requestMapping != null && requestMapping.method().length > 0 ? (Arrays.asList(requestMapping.method()).contains(RequestMethod.POST) ? requestMapping.value() : new String[]{}) : new String[]{}));
            if (putMapping != null) {
                this.processMethodMapping(method, controllerClass, classPath, "PUT", putMapping.value());
            }
            if (deleteMapping != null) {
                this.processMethodMapping(method, controllerClass, classPath, "DELETE", deleteMapping.value());
            }
            if (patchMapping == null) continue;
            this.processMethodMapping(method, controllerClass, classPath, "PATCH", patchMapping.value());
        }
    }

    private void processMethodMapping(Method method, Class<?> controllerClass, String classPath, String httpMethod, String[] methodPaths) {
        if (methodPaths.length == 0) {
            String fullPath = this.buildFullPath(classPath, "");
            this.addPathInfo(fullPath, controllerClass, method, httpMethod);
            return;
        }
        for (String methodPath : methodPaths) {
            String fullPath = this.buildFullPath(classPath, methodPath);
            this.addPathInfo(fullPath, controllerClass, method, httpMethod);
        }
    }

    private String buildFullPath(String classPath, String methodPath) {
        Object result;
        StringBuilder fullPath = new StringBuilder();
        if (StringUtils.hasText((String)classPath)) {
            fullPath.append(this.normalizePath(classPath));
        }
        if (StringUtils.hasText((String)methodPath)) {
            String normalizedMethodPath = this.normalizePath(methodPath);
            if (!normalizedMethodPath.startsWith("/") && fullPath.length() > 0) {
                fullPath.append("/");
            }
            fullPath.append(normalizedMethodPath);
        }
        if (!((String)(result = fullPath.toString())).startsWith("/")) {
            result = "/" + (String)result;
        }
        return result;
    }

    private String normalizePath(String path) {
        if (!StringUtils.hasText((String)path)) {
            return "";
        }
        String normalized = path.trim();
        while (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        normalized = normalized.replaceAll("/+", "/");
        return normalized;
    }

    private void addPathInfo(String fullPath, Class<?> controllerClass, Method method, String httpMethod) {
        String key = httpMethod + ":" + fullPath;
        NotCheckLoginPathInfo pathInfo = new NotCheckLoginPathInfo(fullPath, controllerClass.getName(), method.getName(), httpMethod, method);
        this.notCheckLoginPaths.put(key, pathInfo);
        String controllerName = controllerClass.getSimpleName();
        this.controllerPaths.computeIfAbsent(controllerName, k -> new ArrayList()).add(pathInfo);
    }

    private Class<?> getTargetClass(Class<?> clazz) {
        Class<?> targetClass = clazz;
        while (targetClass.getName().contains("$$")) {
            targetClass = targetClass.getSuperclass();
        }
        return targetClass;
    }

    private void printScanResult() {
        if (this.notCheckLoginPaths.isEmpty()) {
            log.warn("\u672a\u627e\u5230\u4efb\u4f55\u5e26\u6709@NotCheckLogin\u6ce8\u89e3\u7684\u63a5\u53e3");
            return;
        }
        log.info("========== \u4e0d\u9700\u8981\u767b\u5f55\u68c0\u67e5\u7684\u63a5\u53e3\u5217\u8868 ==========");
        this.controllerPaths.forEach((controllerName, paths) -> {
            log.info("\n\u63a7\u5236\u5668: {}", controllerName);
            paths.forEach(pathInfo -> log.info("  {}", pathInfo));
        });
        log.info("============================================");
    }

    public List<NotCheckLoginPathInfo> getAllNotCheckLoginPaths() {
        return new ArrayList<NotCheckLoginPathInfo>(this.notCheckLoginPaths.values());
    }

    public Map<String, List<NotCheckLoginPathInfo>> getPathsByController() {
        return new HashMap<String, List<NotCheckLoginPathInfo>>(this.controllerPaths);
    }

    public boolean isNotCheckLoginPath(String httpMethod, String requestPath) {
        String key = httpMethod + ":" + requestPath;
        if (this.notCheckLoginPaths.containsKey(key)) {
            return true;
        }
        for (NotCheckLoginPathInfo pathInfo : this.notCheckLoginPaths.values()) {
            if (!pathInfo.getHttpMethod().equalsIgnoreCase(httpMethod) || !this.pathMatches(this.patternToRegex(pathInfo.getFullPath()), requestPath)) continue;
            return true;
        }
        return false;
    }

    private boolean pathMatches(String pattern, String path) {
        if (pattern.equals(path)) {
            return true;
        }
        String regex = pattern.replaceAll("\\{[^/]+\\}", "[^/]+");
        return path.matches(regex);
    }

    private String patternToRegex(String pattern) {
        return pattern.replaceAll("\\{[^/]+\\}", "([^/]+)");
    }

    public List<String> getPathPatterns() {
        return this.notCheckLoginPaths.values().stream().map(NotCheckLoginPathInfo::getFullPath).distinct().sorted().toList();
    }

    public Map<String, List<String>> getHttpMethodPathMap() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        this.notCheckLoginPaths.values().forEach(pathInfo -> result.computeIfAbsent(pathInfo.getHttpMethod(), k -> new ArrayList()).add(pathInfo.getFullPath()));
        return result;
    }
}

