/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.security.encrypt;

import cn.hutool.core.net.url.UrlQuery;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.annotation.EncryptApi;
import com.bringspring.common.constant.GlobalConst;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.EncryptFailException;
import com.bringspring.common.security.wrapper.MyRequestWrapper;
import com.bringspring.common.util.DesUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class EncryptRestInterceptor
implements AsyncHandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptRestInterceptor.class);
    private static final String ENCRYPT_KEY = "encryptData";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            HandlerMethod method;
            EncryptApi methodAnnotation;
            if (handler instanceof HandlerMethod && request instanceof MyRequestWrapper && (methodAnnotation = (EncryptApi)(method = (HandlerMethod)handler).getMethodAnnotation(EncryptApi.class)) != null && methodAnnotation.encryptRequest()) {
                MyRequestWrapper myRequest = (MyRequestWrapper)request;
                String contentType = request.getContentType();
                if (contentType != null) {
                    JSONObject jsonBody;
                    JSON result;
                    myRequest.wrapperRequestData();
                    String requestBody = null;
                    boolean canEncrypt = false;
                    if (StringUtils.substringMatch((CharSequence)contentType, (int)0, (CharSequence)"application/x-www-form-urlencoded") || "get".equalsIgnoreCase(request.getMethod())) {
                        canEncrypt = true;
                        requestBody = this.convertFormToString(request);
                        if ("{}".equals(requestBody)) {
                            requestBody = URLDecoder.decode(myRequest.getRequestBody());
                            Map uriToListToMap = new UrlQuery().parse(requestBody, GlobalConst.DEFAULT_CHARSET).getQueryMap();
                            requestBody = JSONObject.toJSONString((Object)uriToListToMap);
                        }
                    } else if (StringUtils.substringMatch((CharSequence)contentType, (int)0, (CharSequence)"application/json")) {
                        canEncrypt = true;
                        requestBody = myRequest.getRequestBody();
                    }
                    if (canEncrypt && requestBody != null && !"{}".equals(requestBody) && (result = this.decodeApi((JSON)(jsonBody = JSON.parseObject((String)requestBody)))) != null) {
                        myRequest.setRequestBody(result.toJSONString());
                        if (result instanceof JSONObject) {
                            myRequest.addAllParameters((Map)result);
                        }
                        return true;
                    }
                }
                throw this.encryptFailException();
            }
        }
        catch (EncryptFailException eex) {
            throw eex;
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25, \u5f02\u5e38\u5730\u5740\uff1a{}", (Object)request.getServletPath(), (Object)e);
            throw this.encryptFailException();
        }
        return true;
    }

    private String convertFormToString(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            result.put(name, request.getParameter(name));
        }
        try {
            return JSON.toJSONString(result);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public JSON decodeApi(JSON body) {
        try {
            JSONObject jsonObject = (JSONObject)body;
            String content = jsonObject.getOrDefault((Object)ENCRYPT_KEY, (Object)"").toString();
            if (!StringUtils.isEmpty((Object)content)) {
                content = this.decryptData(content);
                return (JSON)JSON.parse((String)content);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25, \u6587\u672c: {}", (Object)body, (Object)e);
        }
        return null;
    }

    protected String decryptData(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            return data;
        }
        if (Objects.equals(Character.valueOf(data.charAt(0)), Character.valueOf('\"')) && Objects.equals(Character.valueOf(data.charAt(data.length() - 1)), Character.valueOf('\"'))) {
            data = data.substring(1, data.length() - 1);
        }
        return DesUtil.aesOrDecode(data, false, true);
    }

    private EncryptFailException encryptFailException() {
        throw new EncryptFailException(MsgCode.FA051.get());
    }
}

