/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.security.filter;

import com.bringspring.common.properties.SecurityProperties;
import com.bringspring.common.security.handler.IRestHandler;
import com.bringspring.common.security.wrapper.MyRequestWrapper;
import com.bringspring.common.security.wrapper.MyResponseWrapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=-97)
public class RequestWrapperFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestWrapperFilter.class);
    private List<IRestHandler> handlers;
    private SecurityProperties securityProperties;

    public RequestWrapperFilter(List<IRestHandler> handlers, SecurityProperties securityProperties) {
        this.handlers = handlers;
        this.securityProperties = securityProperties;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.handlers.isEmpty()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            MyRequestWrapper myRequest = new MyRequestWrapper(request, this.handlers);
            MyResponseWrapper wrapResponse = new MyResponseWrapper(response, this.handlers);
            filterChain.doFilter((ServletRequest)myRequest, (ServletResponse)wrapResponse);
            wrapResponse.doFinal();
        }
    }
}

