/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.bringspring.common.util.ServletUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;

public class CodeUtil {
    public static final String RANDOMCODEKEY = "RANDOMCODEKEY";
    private Random random = new Random();
    private String randString = "abcdefghjklmnopqrstuvwxyz23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    private int width = 120;
    private int height = 40;
    private int lineSize = 10;
    private int stringNum = 4;

    private Font getFont() {
        return new Font("Fixedsys", 1, 18);
    }

    private Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + this.random.nextInt(bc - fc - 16);
        int g = fc + this.random.nextInt(bc - fc - 14);
        int b = fc + this.random.nextInt(bc - fc - 18);
        return new Color(r, g, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRandcode(HttpServletResponse response, Integer stringLength) {
        try {
            HttpSession session = ServletUtils.getSession();
            BufferedImage image = new BufferedImage(this.width, this.height, 4);
            Graphics g = image.getGraphics();
            g.fillRect(0, 0, this.width, this.height);
            g.setFont(new Font("Times New Roman", 0, 20));
            g.setColor(this.getRandColor(110, 133));
            for (int i = 0; i <= this.lineSize; ++i) {
                this.drowLine(g);
            }
            String randomString = "";
            if (Objects.nonNull(stringLength)) {
                this.stringNum = stringLength;
            }
            for (int i = 1; i <= this.stringNum; ++i) {
                randomString = this.drowString(g, randomString, i);
            }
            session.removeAttribute(RANDOMCODEKEY);
            session.setAttribute(RANDOMCODEKEY, (Object)randomString);
            g.dispose();
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)outputStream);
            }
            finally {
                if (Collections.singletonList(outputStream).get(0) != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    private String drowString(Graphics g, String randomString, int i) {
        g.setFont(this.getFont());
        g.setColor(new Color(this.random.nextInt(101), this.random.nextInt(111), this.random.nextInt(121)));
        String rand = String.valueOf(this.getRandomString(this.random.nextInt(this.randString.length())));
        randomString = (String)randomString + rand;
        g.translate(this.random.nextInt(3), this.random.nextInt(3));
        g.drawString(rand, 13 * i, 16);
        return randomString;
    }

    private void drowLine(Graphics g) {
        int x = this.random.nextInt(this.width);
        int y = this.random.nextInt(this.height);
        int xl = this.random.nextInt(13);
        int yl = this.random.nextInt(15);
        g.drawLine(x, y, x + xl, y + yl);
    }

    public String getRandomString(int num) {
        return String.valueOf(this.randString.charAt(num));
    }
}

