/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);
    private static final String IP_URL = "https://sp0.baidu.com/8aQDcjqpAAV3otqbppnN2DJv/api.php?query={ip}&resource_id=6006";
    private static Pattern pattern = Pattern.compile("(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})\\.(1\\d{1,2}|2[0-4]\\d|25[0-5]|\\d{1,2})");
    private static List<Pattern> ipFilterRegexList = new ArrayList<Pattern>();

    public static String getIpAddr() {
        HttpServletRequest request = ServletUtils.getRequest();
        String xIp = request.getHeader("X-Real-IP");
        String xFor = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty(xFor) && !"unKnown".equalsIgnoreCase(xFor)) {
            int index = xFor.indexOf(",");
            if (index != -1) {
                return xFor.substring(0, index);
            }
            return xFor;
        }
        xFor = xIp;
        if (StringUtils.isNotEmpty(xFor) && !"unKnown".equalsIgnoreCase(xFor)) {
            return xFor;
        }
        if (StringUtils.isBlank((CharSequence)xFor) || "unknown".equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)xFor) || "unknown".equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)xFor) || "unknown".equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)xFor) || "unknown".equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((CharSequence)xFor) || "unknown".equalsIgnoreCase(xFor)) {
            xFor = request.getRemoteAddr();
        }
        String ip = "0:0:0:0:0:0:0:1".equals(xFor) ? "127.0.0.1" : xFor;
        return ip;
    }

    public static boolean isValid(String ip) {
        Matcher m = pattern.matcher(ip);
        return m.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject getIpInfo(String ip) {
        JSONObject data = null;
        if (IpUtil.ipIsInner(ip)) return data;
        long begin = System.currentTimeMillis();
        try {
            String ipUrl = IP_URL.replace("{ip}", ip);
            URL url = new URL(ipUrl);
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setRequestMethod("GET");
            httpUrlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            httpUrlConnection.setDoInput(true);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setReadTimeout(3000);
            httpUrlConnection.setConnectTimeout(3000);
            InputStream inputStream = httpUrlConnection.getInputStream();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    block15: {
                        byte[] b = new byte[1024];
                        int len = 0;
                        while (true) {
                            if ((len = inputStream.read(b)) == -1) {
                                long end = System.currentTimeMillis() - begin;
                                byte[] lens = byteArrayOutputStream.toByteArray();
                                String result = new String(lens, "GBK");
                                data = JSONObject.parseObject((String)result);
                                if (null == data) {
                                    break;
                                }
                                break block15;
                            }
                            byteArrayOutputStream.write(b, 0, len);
                        }
                        JSONObject jSONObject = data;
                        return jSONObject;
                    }
                    data = JSONObject.parseObject((String)data.getJSONArray("data").get(0).toString());
                    return data;
                }
                finally {
                    if (Collections.singletonList(byteArrayOutputStream).get(0) != null) {
                        byteArrayOutputStream.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            log.error("ip\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ip\u63a5\u53e3\u5de5\u5177IPUtil\u3002");
        }
        return data;
    }

    public static String getIpCity(String ip) {
        String ipInfo = null;
        if (ip != null) {
            JSONObject data = IpUtil.getIpInfo(ip);
            if (null == data) {
                ipInfo = "127.0.0.1".equals(ip) || "localhost".equals(ip) ? "\u672c\u5730\u8fde\u63a5" : "\u672c\u5730\u5c40\u57df\u7f51";
                return ipInfo;
            }
            ipInfo = data.getString("location");
            return ipInfo;
        }
        return ipInfo;
    }

    public static boolean ipIsInner(String ip) {
        boolean isInnerIp = false;
        for (Pattern tmp : ipFilterRegexList) {
            Matcher matcher = tmp.matcher(ip);
            if (!matcher.find()) continue;
            isInnerIp = true;
            break;
        }
        return isInnerIp;
    }

    static {
        HashSet<String> ipFilter = new HashSet<String>();
        ipFilter.add("^10\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[0-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[0-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[0-9])$");
        ipFilter.add("^172\\.(1[6789]|2[0-9]|3[01])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[0-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[0-9])$");
        ipFilter.add("^192\\.168\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[0-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[0-9])$");
        ipFilter.add("127.0.0.1");
        ipFilter.add("0.0.0.0");
        ipFilter.add("localhost");
        for (String tmp : ipFilter) {
            ipFilterRegexList.add(Pattern.compile(tmp));
        }
    }
}

