package com.bringspring.common.database.plugins;


import com.bringspring.common.database.model.DataSourceModel;

/**
 * 动态生成数据源接口
 *
 * @author RKKJ开发平台组
 * @copyright 荣科科技股份有限公司
 */
public interface DynamicSourceGeneratorInterface {

    /**
     * 获取当前需要切换的数据源配置
     * @return
     */
    DataSourceModel getDataSource();

    /**
     * 是否缓存链接
     * @return true: 不可用时重新获取, false: 每次都重新获取配置
     */
    default boolean cachedConnection(){
        return true;
    }

}
