package com.bringspring.common.filter;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import org.apache.http.Consts;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;

/**
 * @author rikylinz
 * @description 防重复提交
 * @date 2022/11/15 14:35
 */
@Component
public abstract class RepeatSubmitInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            Method method = handlerMethod.getMethod();
            RepeatSubmit annotation = method.getAnnotation(RepeatSubmit.class);
            boolean isUpdateMethod = false;
            // TODO: 2024/4/11 先注释，因为有查询列表的接口是POST请求
//            if ("POST,PUT,DELETE".contains(request.getMethod().toUpperCase()))
//                isUpdateMethod = true;
            if (annotation != null ) {
                if (this.isRepeatSubmit(request, annotation))
                {
                    this.result(response, ActionResult.fail("不允许重复提交，请稍候再试"));
//                    this.result(response, JSON.toJSONString(annotation.message()));
                    return false;
                }
            }else{ // 没有使用注解，如果是POST,PUT,DELETE请求，也拦截重复提交

            }

//            if (this.isRepeatSubmit(request, null))
//            {
////                this.result(response, JSON.toJSONString("不允许重复提交，请稍候再试"));
//                this.result(response, ActionResult.fail("不允许重复提交，请稍候再试"));
//                return false;
//            }
            return true;
        } else {
            return true;
        }
    }

    /**
     * 验证是否重复提交由子类实现具体的防重复提交的规则，待实现
     *
     * @param request
     * @return
     * @throws Exception
     */
    public abstract boolean isRepeatSubmit(HttpServletRequest request, RepeatSubmit annotation);

    /**
     * 被拦截后返回给调用者的信息
     * @param response  响应
     * @param res   返回信息
     */
    private void result(HttpServletResponse response, ActionResult res){
        PrintWriter writer = null;
        try {
            response.setStatus(200);
            response.setContentType(MediaType.APPLICATION_JSON_UTF8_VALUE);
            response.setCharacterEncoding(Consts.UTF_8.toString());
            writer = response.getWriter();
//            writer.write(res);

//            response.setContentType("application/json;charset=UTF-8");
//            OutputStream out = response.getOutputStream();
//            out.write(res.getMsg().getBytes("UTF-8"));
//            out.flush();
//            out.close();
            response.getWriter().write(JSONObject.toJSON(res).toString());

        } catch (IOException e) {
            throw new RuntimeException(e);
        }finally {
            writer.flush();
            writer.close();
        }
    }
}

