

package com.bringspring.common.nc.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.nc.model.nc.*;
import com.bringspring.common.nc.service.ZXToNcSyncService;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 第三方推送主表
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-02-18
 */
@Slf4j
@RestController
@Api(tags = "凭证推送", value = "nc")
@RequestMapping("/api/nc/vocher")
public class VocherPushController {

    @Autowired
    private ZXToNcSyncService zxToNcSyncService;


    /**
     *
     * @param
     * @return
     */
    @PostMapping("/push")
    public ActionResult push(@RequestBody SupplierVO supplierVO) {
        return ActionResult.success(zxToNcSyncService.syncSupplierToNc(supplierVO));
    }



    /**
     *
     * @param
     * @return
     */
    @PostMapping("/pushCustomer")
    public ActionResult pushCustomer(@RequestBody CustomerVO customerVO) {
        return ActionResult.success(zxToNcSyncService.syncCustomerToNc(customerVO));
    }


    @PostMapping("/pushPsn")
    public ActionResult pushPsn(@RequestBody PsnDocVO psnDocVO) {
        return ActionResult.success(zxToNcSyncService.syncEmployeeToNc(psnDocVO));
    }


    @PostMapping("/pushDept")
    public ActionResult pushDept(@RequestBody DeptVO deptVO) {
        return ActionResult.success(zxToNcSyncService.syncDeptToNc(deptVO));
    }

    @PostMapping("/pushDef")
    public ActionResult pushDef(@RequestBody DefDocVO defDocVO) {
        return ActionResult.success(zxToNcSyncService.syncProjectToNc(defDocVO));
    }


    @PostMapping("/pushOrg")
    public ActionResult pushOrg(@RequestBody OrgUnitVO orgUnitVO) {
        return ActionResult.success(zxToNcSyncService.syncBusinessUnitToNc(orgUnitVO));
    }

    @PostMapping("/pushMaterial")
    public ActionResult pushMaterial(@RequestBody MaterialVO materialVO) {
        return ActionResult.success(zxToNcSyncService.syncMaterialToNc(materialVO));
    }

}
