package com.bringspring.common.nc.entity.logs;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 第三方数据推送表
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-02-18
 */
@Data
@TableName("ECS_PLATFORM_PUSH_LOGS")
public class NcPlatformPushLogsEntity {

    /** 主键 **/
    @TableId("ID")
    private String id;

//    /** 主表ecs_platform_push主键id **/
//    @TableField("PLATFORM_PUSH_ID")
//    private String platformPushId;

    /** 第三方平台的标识:NC,SK,LQ **/
    @TableField("PLATFORM")
    private String platform;

    /** 业务模块 **/
    @TableField("SOURCE_MODULE")
    private String sourceModule;

    /** 业务单号 **/
    @TableField("CODE")
    private String code;

    /** 业务标题 **/
    @TableField("TITLE")
    private String title;

    /** 业务唯一ID **/
    @TableField("SOURCE_ID")
    private String sourceId;

    /** 推送的原始数据xml? **/
    @TableField("REQUEST_DATA")
    private String requestData;

    /** HTTP方法 **/
    @TableField("REQUEST_METHOD")
    private String requestMethod;

    /** 推送的目标URL **/
    @TableField("REQUEST_URL")
    private String requestUrl;

    /** 推送来源的IP地址 **/
    @TableField("SOURCE_IP")
    private String sourceIp;

    /** 第三方的响应内容 **/
    @TableField("RESPONSE_DATA")
    private String responseData;

    /** HTTP 响应状态码 **/
    @TableField("RESPONSE_STATUS")
    private Integer responseStatus;

    /** 返回响应的时间 **/
    @TableField("RESPONSE_TIME")
    private Date responseTime;

    /** 状态：sucess（成功）、failed（失败） **/
    @TableField("STATUS")
    private String status;

    /** 失败重试次数（默认0) **/
    @TableField("RETRIES")
    private Integer retries;

    /** 创建时间 **/
    @TableField("CREATOR_TIME")
    private Date creatorTime;

    /** 创建用户 **/
    @TableField("CREATOR_USER_ID")
    private String creatorUserId;

}
