package com.bringspring.common.nc.entity.nc.material;

import lombok.Data;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import java.util.List;

/**
 * 物料档案单据头信息
 */
@XmlAccessorType(XmlAccessType.FIELD)
@Data
public class MaterialBillHead {

    // 所属集团 (不能为空)
    private String pk_group;

    // 所属组织 (不能为空)
    private String pk_org;

    // 原始版本
    private String pk_source;

    // 物料编码 (不能为空)
    private String code;

    // 物料名称 (不能为空)
    private String name;

    // 规格
    private String materialspec;

    // 型号
    private String materialtype;

    // 物料简称
    private String materialshortname;

    // 条形码
    private String materialbarcode;

    // 助记码
    private String materialmnecode;

    // 图号
    private String graphid;

    // 主计量单位 (不能为空)
    private String pk_measdoc;

    // 物料分类 (不能为空)
    private String pk_marbasclass;

    // 产品线
    private String pk_prodline;

    // 品牌
    private String pk_brand;

    // 服务类
    private String fee;

    // 价格折扣
    private String discountflag;

    // 成套件
    private String setpartsflag;

    // 产地
    private String prodarea;

    // 产品生命周期
    private Integer prolifeperiod;

    // 长度
    private String unitlength;

    // 高度
    private String unitheight;

    // 宽度
    private String unitwidth;

    // 单位体积
    private String unitvolume;

    // 单位重量
    private String unitweight;

    // 零售
    private String retail;

    // 多少标准存储单位
    private String storeunitnum;

    // 入库容差（%）(不能为空)
    private String intolerance;

    // 出库容差（%）(不能为空)
    private String outtolerance;

    // 出库关闭下容差（%）(不能为空)
    private String outcloselowerlimit;

    // 产品簇
    private String productfamily;

    // 税类
    private String pk_mattaxes;

    // 电子采购
    private String iselectrans;

    // 实物物料管理模式
    private Integer materialmgt;

    // 备注
    private String memo;

    // 启用状态 (2为启用，3为停用) (不能为空)
    private String enablestate;

    // 物料转换信息
    @XmlElementWrapper(name = "materialconvert")
    @XmlElement(name = "item")
    private List<MaterialConvertItem> materialconvert;

    // 物料税类信息
    @XmlElementWrapper(name = "materialtaxtype")
    @XmlElement(name = "item")
    private List<MaterialTaxTypeItem> materialtaxtype;

    // 辅助属性结构
    private String pk_marasstframe;
}
