package com.bringspring.common.nc.entity.nc.psndoc;

import lombok.Data;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import java.util.List;

/**
 * 人员档案单据头信息
 */
@XmlAccessorType(XmlAccessType.FIELD)
@Data
public class PsnDocBillHead {

    // 所属集团
    private String pk_group;

    // 所属业务单元
    private String pk_org;

    // 人员编码
    private String code;

    // 姓名
    private String name;

    // 出生日期
    private String birthdate;

    // 性别 (1为男，2为女)
    private Integer sex;

    // 证件类型 (默认为0：身份证)
    private Integer idtype;

    // 证件号
    private String id;

    // 参加工作日期
    private String joinworkdate;

    // 地址信息
    private AddressVO addressvo;

    // 办公电话
    private String officephone;

    // 家庭电话
    private String homephone;

    // 手机
    private String mobile;

    // 电子邮件
    private String email;

    // 人员工作信息
    @XmlElementWrapper(name = "psnjobs")
    @XmlElement(name = "item")
    private List<PsnJobItem> psnjobs;
}
