package com.bringspring.common.nc.entity.nc.supplier;


import lombok.Data;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import java.util.List;

/**
 * 供应商单据头信息
 */
@XmlAccessorType(XmlAccessType.FIELD)
@Data
public class SupplierBillHead {

    // 所属集团
    private String pk_group;

    // 所属组织
    private String pk_org;

    // 供应商编号
    private String code;

    // 供应商名称
    private String name;

    // 供应商简称
    private String shortname;

    // 外文名称
    private String ename;

    // 助记码
    private String mnecode;

    // 所属行业
    private String trade;

    // 上级供应商
    private String pk_supplier_main;

    // 供应商类型
    private String supprop;

    // 地区分类
    private String pk_areacl;

    // 供应商基本分类
    private String pk_supplierclass;

    // 客户标识
    private String iscustomer;

    // 对应客户
    private String corcustomer;

    // 散户标识
    private String isfreecust;

    // 外部检测机构标识
    private String isoutcheck;

    // 对应财务组织
    private String pk_financeorg;

    // 纳税人登记号
    private String taxpayerid;

    // 注册资金
    private String registerfund;

    // 法人
    private String legalbody;

    // 经济类型
    private String ecotypesincevfive;

    // 供应商税类
    private String pk_suptaxes;

    // 邮编
    private String zipcode;

    // Web网址
    private String url;

    // 备注
    private String memo;

    // 联系人信息
    @XmlElementWrapper(name = "suplinkman")
    @XmlElement(name = "item")
    private List<SupplierLinkManItem> suplinkman;

    // 电话1
    private String tel1;

    // 电话2
    private String tel2;

    // 电话3
    private String tel3;

    // 传真1
    private String fax1;

    // 传真2
    private String fax2;

    // e-mail地址
    private String email;

    // 国家/地区
    private String pk_country;

    // 时区
    private String pk_timezone;

    // 数据格式
    private String pk_format;

    // 启用状态
    private String enablestate;

    // 企业地址信息
    @XmlElement(name = "企业地址")
    private SupplierCorpAddress corpAddress;

    // 企业地址主键
    private String corpaddress;
}
