package com.bringspring.common.nc.service.impl;

import com.bringspring.common.nc.entity.nc.customer.CustomerBill;
import com.bringspring.common.nc.entity.nc.customer.CustomerBillHead;
import com.bringspring.common.nc.entity.nc.customer.CustomerUfInterface;
import com.bringspring.common.nc.entity.nc.dept.DeptBill;
import com.bringspring.common.nc.entity.nc.dept.DeptBillHead;
import com.bringspring.common.nc.entity.nc.dept.DeptUfInterface;
import com.bringspring.common.nc.entity.nc.material.*;
import com.bringspring.common.nc.entity.nc.orgunit.*;
import com.bringspring.common.nc.entity.nc.project.DefDocListBill;
import com.bringspring.common.nc.entity.nc.project.DefDocListBillHead;
import com.bringspring.common.nc.entity.nc.project.DefDocListUfInterface;
import com.bringspring.common.nc.entity.nc.psndoc.PsnDocBill;
import com.bringspring.common.nc.entity.nc.psndoc.PsnDocBillHead;
import com.bringspring.common.nc.entity.nc.psndoc.PsnDocUfInterface;
import com.bringspring.common.nc.entity.nc.psndoc.PsnJobItem;
import com.bringspring.common.nc.entity.nc.supplier.SupplierBill;
import com.bringspring.common.nc.entity.nc.supplier.SupplierBillHead;
import com.bringspring.common.nc.entity.nc.supplier.SupplierUfInterface;
import com.bringspring.common.nc.model.nc.*;
import com.bringspring.common.nc.service.ZXToNcSyncService;
import com.bringspring.common.nc.util.NcSyncUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;

@Slf4j
@Service
public class ZXToNCSyncServiceImpl implements ZXToNcSyncService {

    @Autowired
    private NcSyncUtil ncSyncUtil;

    @Override
    public boolean syncSupplierToNc(SupplierVO supplierVO) {
        SupplierUfInterface ufInterface = new SupplierUfInterface();
        ncSyncUtil.buildCommonUfInterface(ufInterface, "supplier");
        
        SupplierBill supplierBill = new SupplierBill();
        supplierBill.setId(supplierVO.getId());
        
        SupplierBillHead supplierBillHead = new SupplierBillHead();
        supplierBillHead.setPk_group("00");
        supplierBillHead.setPk_org("00");
        supplierBillHead.setCode(supplierVO.getCode());
        supplierBillHead.setName(supplierVO.getName());
        supplierBillHead.setSupprop(supplierVO.getSupprop());
        supplierBillHead.setPk_supplierclass(supplierVO.getPk_supplierclass());
        supplierBillHead.setIscustomer("N");
        supplierBillHead.setSupprop("0");
        supplierBillHead.setTaxpayerid(supplierVO.getTaxpayerid());
        supplierBillHead.setPk_country("CN");
        supplierBillHead.setPk_format("ZH-CN");
        supplierBillHead.setPk_timezone("P0800");
        supplierBillHead.setEnablestate("2");
        
        supplierBill.setBillhead(supplierBillHead);
        ufInterface.setBill(supplierBill);
        
        return ncSyncUtil.syncToNc("NC", supplierVO.getId(), supplierVO.getCode(), supplierVO.getName(), ufInterface);
    }

    @Override
    public boolean syncCustomerToNc(CustomerVO customerVO) {
        CustomerUfInterface ufInterface = new CustomerUfInterface();
        ncSyncUtil.buildCommonUfInterface(ufInterface, "customer");
        
        CustomerBill customerBill = new CustomerBill();
        customerBill.setId(customerVO.getId());
        
        CustomerBillHead customerBillHead = new CustomerBillHead();
        customerBillHead.setPk_group("00");
        customerBillHead.setPk_org("00");
        customerBillHead.setCode(customerVO.getCode());
        customerBillHead.setName(customerVO.getName());
        customerBillHead.setCustprop(customerVO.getCustprop());
        customerBillHead.setPk_custclass(customerVO.getPk_custclass());
        customerBillHead.setTaxpayerid(customerVO.getTaxpayerid());
        customerBillHead.setPk_country("CN");
        customerBillHead.setPk_format("ZH-CN");
        customerBillHead.setPk_timezone("P0800");
        customerBillHead.setEnablestate("2");
        
        customerBill.setBillhead(customerBillHead);
        ufInterface.setBill(customerBill);
        
        return ncSyncUtil.syncToNc("NC", customerVO.getId(), customerVO.getCode(), customerVO.getName(), ufInterface);
    }

    @Override
    public boolean syncEmployeeToNc(PsnDocVO psnDocVO) {
        PsnDocUfInterface ufInterface = new PsnDocUfInterface();
        ncSyncUtil.buildCommonUfInterface(ufInterface, "psndoc");
        
        PsnDocBill psnDocBill = new PsnDocBill();
        psnDocBill.setId(psnDocVO.getId());
        
        PsnDocBillHead psnDocBillHead = new PsnDocBillHead();
        psnDocBillHead.setPk_group("00");
        psnDocBillHead.setPk_org("KGPT-02");
        psnDocBillHead.setCode(psnDocVO.getCode());
        psnDocBillHead.setName(psnDocVO.getName());
        psnDocBillHead.setBirthdate(psnDocVO.getBirthdate());
        psnDocBillHead.setSex(psnDocVO.getSex());
        
        ArrayList<PsnJobItem> arrayList = new ArrayList<>();
        PsnJobItem psnJobItem = new PsnJobItem();
        psnJobItem.setPsncode(psnDocVO.getCode());
        psnJobItem.setPk_org("KGPT-02");
        psnJobItem.setPk_group("00");
        psnJobItem.setPk_psncl(psnDocVO.getPk_psncl());
        psnJobItem.setIsmainjob("Y");
        arrayList.add(psnJobItem);
        psnDocBillHead.setPsnjobs(arrayList);
        
        psnDocBill.setBillhead(psnDocBillHead);
        ufInterface.setBill(psnDocBill);
        
        return ncSyncUtil.syncToNc("NC", psnDocVO.getId(), psnDocVO.getCode(), psnDocVO.getName(), ufInterface);
    }

    @Override
    public boolean syncDeptToNc(DeptVO deptVO) {
        DeptUfInterface ufInterface = new DeptUfInterface();
        ncSyncUtil.buildCommonUfInterface(ufInterface, "dept");
        
        DeptBill deptBill = new DeptBill();
        deptBill.setId(deptVO.getId());
        
        DeptBillHead deptBillHead = new DeptBillHead();
        deptBillHead.setPk_group("00");
        deptBillHead.setPk_org("KGPT-02");
        deptBillHead.setCode(deptVO.getCode());
        deptBillHead.setName(deptVO.getName());
        deptBillHead.setDepttype(deptVO.getDeptType());
        deptBillHead.setPk_fatherorg("23-04");
        
        deptBill.setBillhead(deptBillHead);
        ufInterface.setBill(deptBill);
        
        return ncSyncUtil.syncToNc("NC", deptVO.getId(), deptVO.getCode(), deptVO.getName(), ufInterface);
    }

    @Override
    public boolean syncProjectToNc(DefDocVO defDocVO) {
        DefDocListUfInterface ufInterface = new DefDocListUfInterface();
        ncSyncUtil.buildCommonUfInterface(ufInterface, "defdoclist");
        
        DefDocListBill defDocListBill = new DefDocListBill();
        defDocListBill.setId(defDocVO.getId());
        
        DefDocListBillHead defDocListBillHead = new DefDocListBillHead();
        defDocListBillHead.setPk_group("00");
        defDocListBillHead.setCode(defDocVO.getCode());
        defDocListBillHead.setName(defDocVO.getName());
        defDocListBillHead.setDoctype(defDocVO.getDoctype());
        defDocListBillHead.setIsgrade(defDocVO.getIsgrade());
        defDocListBillHead.setCoderule(defDocVO.getCoderule());
        defDocListBillHead.setCodectlgrade(defDocVO.getCodectlgrade());
        defDocListBillHead.setMngctlmode(defDocVO.getMngctlmode());
        
        defDocListBill.setBillhead(defDocListBillHead);
        ufInterface.setBill(defDocListBill);
        
        return ncSyncUtil.syncToNc("NC", defDocVO.getId(), defDocVO.getCode(), defDocVO.getName(), ufInterface);
    }

    @Override
    public boolean syncBusinessUnitToNc(OrgUnitVO orgUnitVO) {
        OrgUnitUfInterface ufInterface = new OrgUnitUfInterface();
        ncSyncUtil.buildCommonUfInterface(ufInterface, "orgunit");
        
        OrgUnitBill orgUnitBill = new OrgUnitBill();
        orgUnitBill.setId(orgUnitVO.getId());
        
        OrgUnitBillHead orgUnitBillHead = new OrgUnitBillHead();
        OrgUnitAddress orgUnitAddress = new OrgUnitAddress();
        orgUnitAddress.setCode(orgUnitVO.getCode());
        
        OrgUnitOrgVo unitVO = new OrgUnitOrgVo();
        unitVO.setCode(orgUnitVO.getCode());
        unitVO.setName(orgUnitVO.getName());
        unitVO.setPkFatherorg(orgUnitVO.getPkFatherorg());
        unitVO.setPkAccperiodscheme("0001");
        unitVO.setPkCurrtype("CNY");
        unitVO.setEnablestate("2");
        unitVO.setNcindustry("0");
        
        orgUnitBillHead.setAddress(orgUnitAddress);
        orgUnitBillHead.setOrgvo(unitVO);
        orgUnitBill.setBillhead(orgUnitBillHead);
        ufInterface.setBill(orgUnitBill);
        
        return ncSyncUtil.syncToNc("NC", orgUnitVO.getId(), orgUnitVO.getCode(), orgUnitVO.getName(), ufInterface);
    }

    @Override
    public boolean syncMaterialToNc(MaterialVO materialVO) {
        MaterialUfInterface ufInterface = new MaterialUfInterface();
        ncSyncUtil.buildCommonUfInterface(ufInterface, "material");
        
        MaterialBill materialBill = new MaterialBill();
        materialBill.setId(materialVO.getId());
        
        MaterialBillHead materialBillHead = new MaterialBillHead();
        materialBillHead.setPk_group("00");
        materialBillHead.setPk_org(materialVO.getPkOrg());
        materialBillHead.setCode(materialVO.getMaterialCode());
        materialBillHead.setName(materialVO.getMaterialName());
        materialBillHead.setPk_measdoc(materialVO.getUnit());
        materialBillHead.setPk_marbasclass(materialVO.getMaterialType());
        
        materialBillHead.setFee("N");
        materialBillHead.setDiscountflag("N");
        materialBillHead.setSetpartsflag("N");
        materialBillHead.setProductfamily("0");
        materialBillHead.setUnitvolume("0.00000000");
        materialBillHead.setUnitweight("0.00000000");
        materialBillHead.setRetail("N");
        materialBillHead.setStoreunitnum("0.00000000");
        materialBillHead.setIntolerance("0.00000000");
        materialBillHead.setOuttolerance("0.00000000");
        materialBillHead.setOutcloselowerlimit("0.00000000");
        materialBillHead.setProductfamily("N");
        materialBillHead.setPk_mattaxes(materialVO.getTaxClass());
        materialBillHead.setIselectrans("N");
        materialBillHead.setMaterialmgt(0);
        materialBillHead.setEnablestate("2");
        
        // 设置转换项
        ArrayList<MaterialConvertItem> convertItems = new ArrayList<>();
        MaterialConvertItem materialConvertItem = new MaterialConvertItem();
        materialConvertItem.setPk_measdoc(materialVO.getUnit());
        materialConvertItem.setMeasrate("1/1");
        materialConvertItem.setFixedflag("N");
        materialConvertItem.setIsstorebalance("N");
        materialConvertItem.setIspumeasdoc("N");
        materialConvertItem.setIsprodmeasdoc("N");
        materialConvertItem.setIsstockmeasdoc("N");
        materialConvertItem.setIssalemeasdoc("N");
        materialConvertItem.setIsretailmeasdoc("N");
        materialConvertItem.setIspiecemangage("N");
        convertItems.add(materialConvertItem);
        
        // 设置税类型项
        ArrayList<MaterialTaxTypeItem> taxTypeItems = new ArrayList<>();
        MaterialTaxTypeItem materialTaxTypeItem = new MaterialTaxTypeItem();
        materialTaxTypeItem.setPk_countryzone("CN");
        materialTaxTypeItem.setPk_mattaxes(materialVO.getTaxClass());
        taxTypeItems.add(materialTaxTypeItem);
        
        materialBillHead.setMaterialconvert(convertItems);
        materialBillHead.setMaterialtaxtype(taxTypeItems);
        materialBill.setBillhead(materialBillHead);
        ufInterface.setBill(materialBill);
        
        return ncSyncUtil.syncToNc("NC", materialVO.getId(), materialVO.getMaterialCode(), materialVO.getMaterialName(), ufInterface);
    }
}
