package com.bringspring.common.nc.util;


import com.bringspring.common.nc.entity.logs.NcPlatformPushLogsEntity;
import com.bringspring.common.nc.mapper.NcPlatformPushLogsMapper;
import com.bringspring.common.util.RandomUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;

@Service
@Slf4j
public class HttpRequestClientUtil {

    @Value("${nc.url}")
    private String baseUrl;

    // 固定超时时间配置
    private static final int CONNECTION_TIMEOUT = 30000; // 连接超时时间：30秒
    private static final int READ_TIMEOUT = 60000;       // 读取超时时间：60秒

    @Autowired
    private NcPlatformPushLogsMapper platformPushLogsMapper;

    public String sendRequest(String sourceModule, String sourceId, String code, String title, String xmlParam) {
        String responseXml = "";
        String realURL = baseUrl;
        HttpURLConnection con = null;
        int responseCode = -1;
        try {
            con = (HttpURLConnection) new URL(realURL).openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setAllowUserInteraction(false);
            con.setUseCaches(false);
            con.setRequestProperty("Content-type", "text/xml");
            con.setRequestMethod("POST");
            // 设置连接超时时间
            con.setConnectTimeout(CONNECTION_TIMEOUT);
            // 设置读取超时时间
            con.setReadTimeout(READ_TIMEOUT);
            try (DataOutputStream dos = new DataOutputStream(con.getOutputStream())) {
                dos.write(xmlParam.getBytes("GB2312"));
                dos.flush();
            }
            responseCode = con.getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_OK) {
                try (InputStream in = con.getInputStream();
                     InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);
                     BufferedReader br = new BufferedReader(isr)) {

                    StringBuilder rexml = new StringBuilder();
                    String line;
                    while ((line = br.readLine()) != null) {
                        rexml.append(line);
                    }
                    responseXml = rexml.toString();
                }
            } else {
                log.info("连接失败:{}", responseCode);
            }
        } catch (IOException e) {
            log.error("发送请求时发生 I/O 异常: ", e);
        } finally {
            if (con != null) {
                con.disconnect();
            }
            recordPushLog("NC", sourceId, code, title, xmlParam, "POST", realURL, "", responseXml, responseCode);
            log.info("请求结束，响应结果: {}", responseXml);
        }
        return responseXml;
    }



    private void recordPushLog(String platform, String sourceId, String code, String title, String requestData, String requestMethod, String requestUrl, String sourceIp, String responseData, int responseStatus) {
        NcPlatformPushLogsEntity logsEntity = new NcPlatformPushLogsEntity();
        logsEntity.setId(RandomUtil.uuId());
//        logsEntity.setPlatformPushId(platformPushId);
        logsEntity.setPlatform(platform);
        logsEntity.setSourceId(sourceId);
        logsEntity.setCode(code);
        logsEntity.setTitle(title);
        logsEntity.setRequestData(requestData);
        logsEntity.setRequestMethod(requestMethod);
        logsEntity.setRequestUrl(requestUrl);
        logsEntity.setSourceIp(sourceIp);
        logsEntity.setResponseData(responseData);
        logsEntity.setResponseStatus(responseStatus);
        logsEntity.setResponseTime(new Date());
        logsEntity.setStatus(responseStatus == HttpURLConnection.HTTP_OK ? "success" : "failed");
        logsEntity.setRetries(0);
        logsEntity.setCreatorTime(new Date());
        platformPushLogsMapper.insert(logsEntity);
        }


}
