package com.bringspring.common.nc.util;

import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.alibaba.fastjson.JSON;
import com.bringspring.common.nc.entity.nc.material.MaterialUfInterface;
import lombok.extern.slf4j.Slf4j;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamResult;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

@Slf4j
public class XmlConverter {

    /**
     * 对象转xml gb2312
     * @param object
     * @return
     * @param <T>
     */
    public static <T> String convertToXml(T object)  {
        JAXBContext context = null;
        try {
//            convertToXmlAndWriteToFile(object,"凭证");
            context = JAXBContext.newInstance(object.getClass());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
            marshaller.setProperty(Marshaller.JAXB_ENCODING, "GB2312");
            // 使用 ByteArrayOutputStream 捕获输出
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            // 设置 OutputStreamWriter为 GB2312 编码
            OutputStreamWriter writer = new OutputStreamWriter(byteArrayOutputStream, "GB2312");
            marshaller.marshal(object, writer);
            writer.flush();
            // 将字节数组转换为字符串
            return byteArrayOutputStream.toString("GB2312");
        } catch (Exception e) {
            log.error("转换xml失败,{}",e.getMessage());
            throw new RuntimeException(e);
        }

    }

//    public static <T> void convertToXmlAndWriteToFile(T object, String fileName) {
//        JAXBContext context = null;
//        try {
//            // 创建 JAXB 上下文
//            context = JAXBContext.newInstance(object.getClass());
//            Marshaller marshaller = context.createMarshaller();
//            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
//            marshaller.setProperty(Marshaller.JAXB_ENCODING, "GB2312");
//
//            // 使用 ByteArrayOutputStream 捕获输出
//            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
//            // 设置 OutputStreamWriter 为 GB2312 编码
//            OutputStreamWriter writer = new OutputStreamWriter(byteArrayOutputStream, "GB2312");
//            marshaller.marshal(object, writer);
//            writer.flush();
//
//            // 将字节数组转换为字符串
//            String xmlString = byteArrayOutputStream.toString("GB2312");
//
//            // 获取桌面路径
//            String desktopPath = System.getProperty("user.home") + File.separator + "Desktop";
//            // 创建文件对象，确保文件名以 .xml 结尾
//            File xmlFile = new File(desktopPath, fileName.endsWith(".xml") ? fileName : fileName + ".xml");
//
//            // 将 XML 写入文件
//            try (FileOutputStream fileOutputStream = new FileOutputStream(xmlFile)) {
//                fileOutputStream.write(xmlString.getBytes("GB2312"));
//                fileOutputStream.flush();
//                System.out.println("XML 文件已成功写入: " + xmlFile.getAbsolutePath());
//            }
//
//        } catch (Exception e) {
//            log.error("转换xml失败,{}", e.getMessage());
//            throw new RuntimeException(e);
//        }
//    }


    /**
     * 对象转xml gbK
     * @param object
     * @return
     * @param <T>
     */
    public static <T> String convertToGBKXml(T object) {
        try {
            JAXBContext context = JAXBContext.newInstance(object.getClass());
            Marshaller marshaller = context.createMarshaller();

            // 设置编码格式为GBK
            marshaller.setProperty(Marshaller.JAXB_ENCODING, "GBK");
            // 格式化输出
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            // 去掉 standalone="yes"
            marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
//            marshaller.marshal(object, baos);
            // 手动写入 XML 声明头（不带 standalone）
            baos.write("<?xml version=\"1.0\" encoding=\"GBK\"?>".getBytes("GBK"));
            // 序列化对象主体
            marshaller.marshal(object, new StreamResult(baos));
            // 将生成的GBK字节转换为字符串
            return baos.toString("GBK");
        } catch (Exception e) {
            log.error("转换xml失败,{}",e.getMessage());
            throw new RuntimeException(e);
        }

    }


    /**
     * xml转json
     * @param xml
     * @param clazz
     * @return
     * @param <T>
     * @throws JAXBException
     */
    public static <T> T convertXmlToJava(String xml, Class<T> clazz) {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance(clazz);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(xml);
            return (T) unmarshaller.unmarshal(reader);
        } catch (JAXBException e) {
            log.error("xml转换对象失败,{}",e.getMessage());
            throw new RuntimeException(e);
        }

    }


    /**
     * 转换对象
     * @param source
     * @param targetClass
     * @param <T>
     * @param <U>
     * @return   目标对象
     */
    public static <T, U> U convert(T source, Class<U> targetClass) {
        // 将源对象转换为JSON字符串
        String jsonString = JSON.toJSONString(source);
        // 从JSON字符串转换为目标对象
        return JSON.parseObject(jsonString, targetClass);
    }

    /**
     *  xml转json
     * @param xml
     * @return
     */
    public static JSONObject convertXmlToJson(String xml) {
        return XML.toJSONObject(xml);
    }

    public static void main(String[] args) {
            String xml = "<?xml version=\"1.0\" encoding='UTF-8'?>\n" +
                    "<ufinterface account=\"develop\" billtype=\"material\" filename=\"\" groupcode=\"\" isexchange=\"Y\" replace=\"Y\" roottag=\"\" sender=\"003\">\n" +
                    "    <bill id=\"\">\n" +
                    "        <billhead>\n" +
                    "            <pk_group>00</pk_group>\n" +
                    "            <!--所属组织,不能为空,最大长度为20,类型为:String-->\n" +
                    "            <pk_org>02-05</pk_org>\n" +
                    "            <!--原始版本,最大长度为20,类型为:String-->\n" +
                    "            <pk_source></pk_source>\n" +
                    "            <!--物料编码,不能为空,最大长度为40,类型为:String-->\n" +
                    "            <code>rkcswl001</code>\n" +
                    "            <!--物料名称,不能为空,最大长度为200,类型为:String-->\n" +
                    "            <name>荣科测试物料01</name>\n" +
                    "            <!--规格,最大长度为50,类型为:String-->\n" +
                    "            <materialspec></materialspec>\n" +
                    "            <!--型号,最大长度为50,类型为:String-->\n" +
                    "            <materialtype></materialtype>\n" +
                    "            <!--物料简称,最大长度为200,类型为:String-->\n" +
                    "            <materialshortname></materialshortname>\n" +
                    "            <!--条形码,最大长度为30,类型为:String-->\n" +
                    "            <materialbarcode></materialbarcode>\n" +
                    "            <!--助记码,最大长度为50,类型为:String-->\n" +
                    "            <materialmnecode></materialmnecode>\n" +
                    "            <!--图号,最大长度为50,类型为:String-->\n" +
                    "            <graphid></graphid>\n" +
                    "            <!--主计量单位,不能为空,最大长度为20,类型为:String-->\n" +
                    "            <pk_measdoc>KGM</pk_measdoc>\n" +
                    "            <!--物料分类,不能为空,最大长度为20,类型为:String-->\n" +
                    "            <pk_marbasclass>0107</pk_marbasclass>\n" +
                    "            <!--产品线,最大长度为20,类型为:String-->\n" +
                    "            <pk_prodline></pk_prodline>\n" +
                    "            <!--品牌,最大长度为20,类型为:String-->\n" +
                    "            <pk_brand></pk_brand>\n" +
                    "            <!--服务类,最大长度为1,类型为:UFBoolean-->\n" +
                    "            <fee>N</fee>\n" +
                    "            <!--价格折扣,最大长度为1,类型为:UFBoolean-->\n" +
                    "            <discountflag>N</discountflag>\n" +
                    "            <!--成套件,最大长度为1,类型为:UFBoolean-->\n" +
                    "            <setpartsflag>N</setpartsflag>\n" +
                    "            <!--产地,最大长度为20,类型为:String-->\n" +
                    "            <prodarea></prodarea>\n" +
                    "            <!--产品生命周期,最大长度为0,类型为:Integer-->\n" +
                    "            <prolifeperiod>0</prolifeperiod>\n" +
                    "            <!--长度,最大长度为20,类型为:String-->\n" +
                    "            <unitlength></unitlength>\n" +
                    "            <!--高度,最大长度为20,类型为:String-->\n" +
                    "            <unitheight></unitheight>\n" +
                    "            <!--宽度,最大长度为20,类型为:String-->\n" +
                    "            <unitwidth></unitwidth>\n" +
                    "            <!--单位体积,最大长度为20,类型为:UFDouble-->\n" +
                    "            <unitvolume>0.00000000</unitvolume>\n" +
                    "            <!--单位重量,最大长度为20,类型为:UFDouble-->\n" +
                    "            <unitweight>0.00000000</unitweight>\n" +
                    "            <!--零售,最大长度为1,类型为:UFBoolean-->\n" +
                    "            <retail>N</retail>\n" +
                    "            <!--多少标准存储单位,最大长度为20,类型为:UFDouble-->\n" +
                    "            <storeunitnum>0.00000000</storeunitnum>\n" +
                    "            <!--入库容差（%）,不能为空,最大长度为20,类型为:UFDouble-->\n" +
                    "            <intolerance>0.00000000</intolerance>\n" +
                    "            <!--出库容差（%）,不能为空,最大长度为20,类型为:UFDouble-->\n" +
                    "            <outtolerance>0.00000000</outtolerance>\n" +
                    "            <!--出库关闭下容差（%）,不能为空,最大长度为20,类型为:UFDouble-->\n" +
                    "            <outcloselowerlimit>0.00000000</outcloselowerlimit>\n" +
                    "            <!--产品簇,最大长度为1,类型为:UFBoolean-->\n" +
                    "            <productfamily>N</productfamily>\n" +
                    "            <!--税类,最大长度为20,类型为:String-->\n" +
                    "            <pk_mattaxes>KGPT04</pk_mattaxes>\n" +
                    "            <!--电子采购,最大长度为1,类型为:UFBoolean-->\n" +
                    "            <iselectrans>N</iselectrans>\n" +
                    "            <!--实物物料管理模式,最大长度为0,类型为:Integer-->\n" +
                    "            <materialmgt>0</materialmgt>\n" +
                    "            <memo>\n" +
                    "            </memo>\n" +
                    "            <!--启用状态,不能为空,最大长度为1,类型为:Integer 2为启用，3为停用-->\n" +
                    "            <enablestate>2</enablestate>\n" +
                    "            <materialconvert>\n" +
                    "                <item>\n" +
                    "                    <!--计量单位名称,不能为空,最大长度为20,类型为:String-->\n" +
                    "                    <pk_measdoc>KGM</pk_measdoc>\n" +
                    "                    <!--与主计量单位换算系数,不能为空,最大长度为50,类型为:String-->\n" +
                    "                    <measrate>1/1</measrate>\n" +
                    "                    <!--固定换算,最大长度为1,类型为:UFBoolean-->\n" +
                    "                    <fixedflag>N</fixedflag>\n" +
                    "                    <!--结存,最大长度为1,类型为:UFBoolean-->\n" +
                    "                    <isstorebalance>N</isstorebalance>\n" +
                    "                    <!--采购默认单位,最大长度为1,类型为:UFBoolean-->\n" +
                    "                    <ispumeasdoc>N</ispumeasdoc>\n" +
                    "                    <!--生产默认单位,最大长度为1,类型为:UFBoolean-->\n" +
                    "                    <isprodmeasdoc>N</isprodmeasdoc>\n" +
                    "                    <!--库存默认单位,最大长度为1,类型为:UFBoolean-->\n" +
                    "                    <isstockmeasdoc>N</isstockmeasdoc>\n" +
                    "                    <!--销售默认单位,最大长度为1,类型为:UFBoolean-->\n" +
                    "                    <issalemeasdoc>N</issalemeasdoc>\n" +
                    "                    <!--零售默认单位,最大长度为1,类型为:UFBoolean-->\n" +
                    "                    <isretailmeasdoc>N</isretailmeasdoc>\n" +
                    "                    <!--件数管理,最大长度为1,类型为:UFBoolean-->\n" +
                    "                    <ispiecemangage>N</ispiecemangage>\n" +
                    "                </item>\n" +
                    "            </materialconvert>\n" +
                    "            <materialtaxtype>\n" +
                    "                <item>\n" +
                    "                    <!--国家名称,不能为空,最大长度为20,类型为:String-->\n" +
                    "                    <pk_countryzone>CN</pk_countryzone>\n" +
                    "                    <!--税类名称,不能为空,最大长度为20,类型为:String-->\n" +
                    "                    <pk_mattaxes>KGPT04</pk_mattaxes>\n" +
                    "                </item>\n" +
                    "            </materialtaxtype>\n" +
                    "            <!--辅助属性结构,最大长度为20,类型为:String-->\n" +
                    "            <pk_marasstframe></pk_marasstframe>\n" +
                    "        </billhead>\n" +
                    "    </bill>\n" +
                    "</ufinterface>";
        MaterialUfInterface materialUfInterface = convertXmlToJava(xml, MaterialUfInterface.class);
//        SingleStream stream = convertXmlToJava(xml, SingleStream.class);
//        System.out.println("Account: " + JSONUtil.toJsonStr(stream));
//            String toXml = convertToGBKXml(stream);
            sendRequest(xml);


    }


    public static String sendRequest(String xmlParam)  {
        String responseXml = "";
        String realURL = "http://39.99.147.197:6789";
        HttpURLConnection con = null;
        int responseCode = -1;
        try {
            con = (HttpURLConnection) new URL(realURL).openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setAllowUserInteraction(false);
            con.setUseCaches(false);
            con.setRequestProperty("Content-type", "text/xml");
            con.setRequestMethod("POST");
            try (DataOutputStream dos = new DataOutputStream(con.getOutputStream())) {
                dos.write(xmlParam.getBytes("GBK"));
                dos.flush();
            }
            responseCode = con.getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_OK) {
                try (InputStream in = con.getInputStream();
                     InputStreamReader isr = new InputStreamReader(in, "GBK");
                     BufferedReader br = new BufferedReader(isr)) {

                    StringBuilder rexml = new StringBuilder();
                    String line;
                    while ((line = br.readLine()) != null) {
                        rexml.append(line);
                    }
                    responseXml = rexml.toString();
                }
            } else {
                log.info("连接失败:{}", responseCode);
            }
        } catch (IOException e) {
            log.error("发送请求时发生 I/O 异常: ", e);
        } finally {
            if (con != null) {
                con.disconnect();
            }
            log.info("请求结束，响应结果: {}", responseXml);
        }
        return responseXml;
    }
}
