/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.filter;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.license.client.LicenseVerify;
import com.bringspring.common.license.license.CustomLicenseManager;
import com.bringspring.common.license.license.model.LicenseCheckModel;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.jwt.JwtUtil;
import de.schlichtherle.license.LicenseContentException;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class TokenInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TokenInterceptor.class);
    private UserProvider userProvider;
    private ConfigValueUtil configValueUtil;
    private CacheUtil cacheUtil;
    private RedisUtil redisUtil;

    private void init() {
        this.userProvider = SpringContext.getBean(UserProvider.class);
        this.configValueUtil = SpringContext.getBean(ConfigValueUtil.class);
        this.cacheUtil = SpringContext.getBean(CacheUtil.class);
        this.redisUtil = SpringContext.getBean(RedisUtil.class);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.init();
        String method = request.getMethod();
        if ("OPTIONS".equals(method)) {
            return true;
        }
        LicenseVerify licenseVerify = new LicenseVerify();
        boolean verifyResult = licenseVerify.verify();
        if (!verifyResult) {
            ActionResult<JSONObject> result = ActionResult.fail(ActionResultCode.LicenseError.getCode(), ActionResultCode.LicenseError.getMessage());
            CustomLicenseManager customLicenseManager = new CustomLicenseManager();
            LicenseCheckModel model = customLicenseManager.getServerInfos();
            if (StringUtils.isEmpty(model.getCpuSerial(), model.getMainBoardSerial())) {
                throw new LicenseContentException("Cpu\u6216\u4e3b\u677f\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String pcCode = Md5Util.getStringMd5(JSONObject.toJSONString((Object)model));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("machineCode", (Object)pcCode);
            jsonObject.put("isExist", (Object)false);
            result.setData(jsonObject);
            ServletUtils.renderString(response, JsonUtil.getObjectToString(result));
            return false;
        }
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            UserInfo userInfo = this.userProvider.get();
            DataSourceContextHolder.setDatasource(userInfo.getTenantId(), userInfo.getTenantDbConnectionString());
        }
        String token = UserProvider.getToken();
        boolean notCheckLogin = false;
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            notCheckLogin = handlerMethod.hasMethodAnnotation(NotCheckLogin.class);
        }
        if (!notCheckLogin && "false".equals(this.configValueUtil.getTestVersion())) {
            return this.tokenByPass(request, response, token);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            DataSourceContextHolder.clearDatasourceType();
        }
    }

    private void tokenTimeout(UserInfo userInfo) {
        String tenantId = StringUtils.isNotEmpty(userInfo.getTenantId()) ? userInfo.getTenantId() : "";
        String userId = userInfo.getUserId();
        String onlineInfo = tenantId + "login_online_" + userId;
        this.cacheUtil.expire("loginCacheSpace", onlineInfo, userInfo.getTokenTimeout() * 60);
        this.cacheUtil.expire("loginCacheSpace", userInfo.getId(), userInfo.getTokenTimeout() * 60);
    }

    public String getSessionIdFromRequest(HttpServletRequest request) {
        String sessionId = request.getHeader("JSESSIONID");
        if (StringUtils.isNotEmpty(sessionId)) {
            return sessionId;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"JSESSIONID".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return request.getSession().getId();
    }

    private boolean tokenByPass(HttpServletRequest request, HttpServletResponse response, String token) {
        String sessionId = this.getSessionIdFromRequest(request);
        UserInfo userInfo = this.userProvider.get();
        String realToken = JwtUtil.getRealToken(token);
        if (StringUtils.isEmpty(realToken) || !this.cacheUtil.exists("loginCacheSpace", realToken)) {
            Boolean isSuccess = this.redisUtil.getLock(sessionId, "\u9000\u51fa\u767b\u5f55");
            log.info("isSuccess:{}", (Object)isSuccess);
            ActionResultCode sessionOverdue = ActionResultCode.SessionOverdue;
            if (!isSuccess.booleanValue()) {
                sessionOverdue = ActionResultCode.SessionRepeatError;
            }
            ActionResult result = ActionResult.fail(sessionOverdue.getCode(), sessionOverdue.getMessage());
            ServletUtils.renderString(response, JsonUtil.getObjectToString(result));
            return false;
        }
        Date exp = JwtUtil.getExp(token);
        if (exp.getTime() < System.currentTimeMillis()) {
            Boolean isSuccess = this.redisUtil.getLock(sessionId, "\u9000\u51fa\u767b\u5f55");
            log.info("isSuccess:{}", (Object)isSuccess);
            ActionResultCode sessionOverdue = ActionResultCode.SessionOverdue;
            if (!isSuccess.booleanValue()) {
                sessionOverdue = ActionResultCode.SessionRepeatError;
            }
            ActionResult result = ActionResult.fail(sessionOverdue.getCode(), sessionOverdue.getMessage());
            ServletUtils.renderString(response, JsonUtil.getObjectToString(result));
            return false;
        }
        Integer singleLogin = JwtUtil.getSingleLogin(token);
        if (!"1".equals(String.valueOf(singleLogin)) && !this.userProvider.isOnLine()) {
            ActionResult result = ActionResult.fail(ActionResultCode.SessionOffLine.getCode(), ActionResultCode.SessionOffLine.getMessage());
            this.cacheUtil.remove("loginCacheSpace", realToken);
            ServletUtils.renderString(response, JsonUtil.getObjectToString(result));
            return false;
        }
        this.tokenTimeout(userInfo);
        return true;
    }
}

