/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.nc.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.nc.model.nc.CustomerVO;
import com.bringspring.common.nc.model.nc.DefDocVO;
import com.bringspring.common.nc.model.nc.DeptVO;
import com.bringspring.common.nc.model.nc.MaterialVO;
import com.bringspring.common.nc.model.nc.OrgUnitVO;
import com.bringspring.common.nc.model.nc.PsnDocVO;
import com.bringspring.common.nc.model.nc.SupplierVO;
import com.bringspring.common.nc.service.ZXToNcSyncService;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u51ed\u8bc1\u63a8\u9001"}, value="nc")
@RequestMapping(value={"/api/nc/vocher"})
public class VocherPushController {
    private static final Logger log = LoggerFactory.getLogger(VocherPushController.class);
    @Autowired
    private ZXToNcSyncService zxToNcSyncService;

    @PostMapping(value={"/push"})
    public ActionResult push(@RequestBody SupplierVO supplierVO) {
        return ActionResult.success(this.zxToNcSyncService.syncSupplierToNc(supplierVO));
    }

    @PostMapping(value={"/pushCustomer"})
    public ActionResult pushCustomer(@RequestBody CustomerVO customerVO) {
        return ActionResult.success(this.zxToNcSyncService.syncCustomerToNc(customerVO));
    }

    @PostMapping(value={"/pushPsn"})
    public ActionResult pushPsn(@RequestBody PsnDocVO psnDocVO) {
        return ActionResult.success(this.zxToNcSyncService.syncEmployeeToNc(psnDocVO));
    }

    @PostMapping(value={"/pushDept"})
    public ActionResult pushDept(@RequestBody DeptVO deptVO) {
        return ActionResult.success(this.zxToNcSyncService.syncDeptToNc(deptVO));
    }

    @PostMapping(value={"/pushDef"})
    public ActionResult pushDef(@RequestBody DefDocVO defDocVO) {
        return ActionResult.success(this.zxToNcSyncService.syncProjectToNc(defDocVO));
    }

    @PostMapping(value={"/pushOrg"})
    public ActionResult pushOrg(@RequestBody OrgUnitVO orgUnitVO) {
        return ActionResult.success(this.zxToNcSyncService.syncBusinessUnitToNc(orgUnitVO));
    }

    @PostMapping(value={"/pushMaterial"})
    public ActionResult pushMaterial(@RequestBody MaterialVO materialVO) {
        return ActionResult.success(this.zxToNcSyncService.syncMaterialToNc(materialVO));
    }
}

