/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.nc.util;

import com.bringspring.common.nc.entity.logs.NcPlatformPushLogsEntity;
import com.bringspring.common.nc.mapper.NcPlatformPushLogsMapper;
import com.bringspring.common.util.RandomUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HttpRequestClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestClientUtil.class);
    @Value(value="${nc.url}")
    private String baseUrl;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 60000;
    @Autowired
    private NcPlatformPushLogsMapper platformPushLogsMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendRequest(String sourceModule, String sourceId, String code, String title, String xmlParam) {
        String responseXml;
        block57: {
            responseXml = "";
            String realURL = this.baseUrl;
            HttpURLConnection con = null;
            int responseCode = -1;
            try {
                con = (HttpURLConnection)new URL(realURL).openConnection();
                con.setDoOutput(true);
                con.setDoInput(true);
                con.setAllowUserInteraction(false);
                con.setUseCaches(false);
                con.setRequestProperty("Content-type", "text/xml");
                con.setRequestMethod("POST");
                con.setConnectTimeout(30000);
                con.setReadTimeout(60000);
                try (DataOutputStream dos = new DataOutputStream(con.getOutputStream());){
                    dos.write(xmlParam.getBytes("GB2312"));
                    dos.flush();
                }
                responseCode = con.getResponseCode();
                if (responseCode == 200) {
                    var11_12 = null;
                    try (InputStream in = con.getInputStream();
                         InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);
                         BufferedReader br = new BufferedReader(isr);){
                        String line;
                        StringBuilder rexml = new StringBuilder();
                        while ((line = br.readLine()) != null) {
                            rexml.append(line);
                        }
                        responseXml = rexml.toString();
                        break block57;
                    }
                    catch (Throwable throwable) {
                        var11_12 = throwable;
                        throw throwable;
                    }
                }
                log.info("\u8fde\u63a5\u5931\u8d25:{}", (Object)responseCode);
            }
            catch (IOException e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u65f6\u53d1\u751f I/O \u5f02\u5e38: ", (Throwable)e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
                this.recordPushLog("NC", sourceId, code, title, xmlParam, "POST", realURL, "", responseXml, responseCode);
                log.info("\u8bf7\u6c42\u7ed3\u675f\uff0c\u54cd\u5e94\u7ed3\u679c: {}", (Object)responseXml);
            }
        }
        return responseXml;
    }

    private void recordPushLog(String platform, String sourceId, String code, String title, String requestData, String requestMethod, String requestUrl, String sourceIp, String responseData, int responseStatus) {
        NcPlatformPushLogsEntity logsEntity = new NcPlatformPushLogsEntity();
        logsEntity.setId(RandomUtil.uuId());
        logsEntity.setPlatform(platform);
        logsEntity.setSourceId(sourceId);
        logsEntity.setCode(code);
        logsEntity.setTitle(title);
        logsEntity.setRequestData(requestData);
        logsEntity.setRequestMethod(requestMethod);
        logsEntity.setRequestUrl(requestUrl);
        logsEntity.setSourceIp(sourceIp);
        logsEntity.setResponseData(responseData);
        logsEntity.setResponseStatus(responseStatus);
        logsEntity.setResponseTime(new Date());
        logsEntity.setStatus(responseStatus == 200 ? "success" : "failed");
        logsEntity.setRetries(0);
        logsEntity.setCreatorTime(new Date());
        this.platformPushLogsMapper.insert(logsEntity);
    }
}

