/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.nc.util;

import cn.hutool.json.JSONObject;
import com.bringspring.common.nc.util.HttpRequestClientUtil;
import com.bringspring.common.nc.util.XmlConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NcSyncUtil {
    private static final Logger log = LoggerFactory.getLogger(NcSyncUtil.class);
    @Autowired
    private HttpRequestClientUtil httpClientUtil;

    public boolean syncToNc(String moduleType, String dataId, String dataCode, String dataName, Object ufInterface) {
        try {
            String toXml = XmlConverter.convertToXml(ufInterface);
            log.info("\u6570\u636e\u63a8\u9001\u5230NC\uff0c\u5165\u53c2: {}", (Object)XmlConverter.convertXmlToJson(toXml));
            String sendRequest = this.httpClientUtil.sendRequest(moduleType, dataId, dataCode, dataName, toXml);
            log.info("NC\u54cd\u5e94\u7ed3\u679c: {}", (Object)sendRequest);
            return this.processResponse(sendRequest);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u6570\u636e\u5230NC\u5931\u8d25\uff0c\u6570\u636eID: {}, \u9519\u8bef\u4fe1\u606f: {}", new Object[]{dataId, e.getMessage(), e});
            return false;
        }
    }

    public boolean processResponse(String response) {
        try {
            if (response == null || response.trim().isEmpty()) {
                log.warn("NC\u54cd\u5e94\u4e3a\u7a7a");
                return false;
            }
            JSONObject jsonObject = XmlConverter.convertXmlToJson(response);
            JSONObject sendResult = jsonObject.getJSONObject((Object)"ufinterface").getJSONObject((Object)"sendresult");
            return sendResult != null && sendResult.getInt((Object)"resultcode") == 1;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790NC\u54cd\u5e94\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public void buildCommonUfInterface(Object ufInterface, String billType) {
        try {
            ufInterface.getClass().getMethod("setAccount", String.class).invoke(ufInterface, "RKJT");
            ufInterface.getClass().getMethod("setBilltype", String.class).invoke(ufInterface, billType);
            ufInterface.getClass().getMethod("setGroupcode", String.class).invoke(ufInterface, "00");
            ufInterface.getClass().getMethod("setFilename", String.class).invoke(ufInterface, "");
            ufInterface.getClass().getMethod("setIsexchange", String.class).invoke(ufInterface, "Y");
            ufInterface.getClass().getMethod("setReplace", String.class).invoke(ufInterface, "Y");
            ufInterface.getClass().getMethod("setRoottag", String.class).invoke(ufInterface, "");
            ufInterface.getClass().getMethod("setSender", String.class).invoke(ufInterface, "003");
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u901a\u7528UfInterface\u5c5e\u6027\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

