/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.nc.util;

import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.alibaba.fastjson.JSON;
import com.bringspring.common.nc.entity.nc.material.MaterialUfInterface;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConverter {
    private static final Logger log = LoggerFactory.getLogger(XmlConverter.class);

    public static <T> String convertToXml(T object) {
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"GB2312");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "GB2312");
            marshaller.marshal(object, (Writer)writer);
            writer.flush();
            return byteArrayOutputStream.toString("GB2312");
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362xml\u5931\u8d25,{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static <T> String convertToGBKXml(T object) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"GBK");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("<?xml version=\"1.0\" encoding=\"GBK\"?>".getBytes("GBK"));
            marshaller.marshal(object, (Result)new StreamResult(baos));
            return baos.toString("GBK");
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362xml\u5931\u8d25,{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static <T> T convertXmlToJava(String xml, Class<T> clazz) {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(xml);
            return (T)unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            log.error("xml\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25,{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static <T, U> U convert(T source, Class<U> targetClass) {
        String jsonString = JSON.toJSONString(source);
        return (U)JSON.parseObject((String)jsonString, targetClass);
    }

    public static JSONObject convertXmlToJson(String xml) {
        return XML.toJSONObject((String)xml);
    }

    public static void main(String[] args) {
        String xml = "<?xml version=\"1.0\" encoding='UTF-8'?>\n<ufinterface account=\"develop\" billtype=\"material\" filename=\"\" groupcode=\"\" isexchange=\"Y\" replace=\"Y\" roottag=\"\" sender=\"003\">\n    <bill id=\"\">\n        <billhead>\n            <pk_group>00</pk_group>\n            <!--\u6240\u5c5e\u7ec4\u7ec7,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <pk_org>02-05</pk_org>\n            <!--\u539f\u59cb\u7248\u672c,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <pk_source></pk_source>\n            <!--\u7269\u6599\u7f16\u7801,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a40,\u7c7b\u578b\u4e3a:String-->\n            <code>rkcswl001</code>\n            <!--\u7269\u6599\u540d\u79f0,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a200,\u7c7b\u578b\u4e3a:String-->\n            <name>\u8363\u79d1\u6d4b\u8bd5\u7269\u659901</name>\n            <!--\u89c4\u683c,\u6700\u5927\u957f\u5ea6\u4e3a50,\u7c7b\u578b\u4e3a:String-->\n            <materialspec></materialspec>\n            <!--\u578b\u53f7,\u6700\u5927\u957f\u5ea6\u4e3a50,\u7c7b\u578b\u4e3a:String-->\n            <materialtype></materialtype>\n            <!--\u7269\u6599\u7b80\u79f0,\u6700\u5927\u957f\u5ea6\u4e3a200,\u7c7b\u578b\u4e3a:String-->\n            <materialshortname></materialshortname>\n            <!--\u6761\u5f62\u7801,\u6700\u5927\u957f\u5ea6\u4e3a30,\u7c7b\u578b\u4e3a:String-->\n            <materialbarcode></materialbarcode>\n            <!--\u52a9\u8bb0\u7801,\u6700\u5927\u957f\u5ea6\u4e3a50,\u7c7b\u578b\u4e3a:String-->\n            <materialmnecode></materialmnecode>\n            <!--\u56fe\u53f7,\u6700\u5927\u957f\u5ea6\u4e3a50,\u7c7b\u578b\u4e3a:String-->\n            <graphid></graphid>\n            <!--\u4e3b\u8ba1\u91cf\u5355\u4f4d,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <pk_measdoc>KGM</pk_measdoc>\n            <!--\u7269\u6599\u5206\u7c7b,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <pk_marbasclass>0107</pk_marbasclass>\n            <!--\u4ea7\u54c1\u7ebf,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <pk_prodline></pk_prodline>\n            <!--\u54c1\u724c,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <pk_brand></pk_brand>\n            <!--\u670d\u52a1\u7c7b,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n            <fee>N</fee>\n            <!--\u4ef7\u683c\u6298\u6263,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n            <discountflag>N</discountflag>\n            <!--\u6210\u5957\u4ef6,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n            <setpartsflag>N</setpartsflag>\n            <!--\u4ea7\u5730,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <prodarea></prodarea>\n            <!--\u4ea7\u54c1\u751f\u547d\u5468\u671f,\u6700\u5927\u957f\u5ea6\u4e3a0,\u7c7b\u578b\u4e3a:Integer-->\n            <prolifeperiod>0</prolifeperiod>\n            <!--\u957f\u5ea6,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <unitlength></unitlength>\n            <!--\u9ad8\u5ea6,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <unitheight></unitheight>\n            <!--\u5bbd\u5ea6,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <unitwidth></unitwidth>\n            <!--\u5355\u4f4d\u4f53\u79ef,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:UFDouble-->\n            <unitvolume>0.00000000</unitvolume>\n            <!--\u5355\u4f4d\u91cd\u91cf,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:UFDouble-->\n            <unitweight>0.00000000</unitweight>\n            <!--\u96f6\u552e,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n            <retail>N</retail>\n            <!--\u591a\u5c11\u6807\u51c6\u5b58\u50a8\u5355\u4f4d,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:UFDouble-->\n            <storeunitnum>0.00000000</storeunitnum>\n            <!--\u5165\u5e93\u5bb9\u5dee\uff08%\uff09,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:UFDouble-->\n            <intolerance>0.00000000</intolerance>\n            <!--\u51fa\u5e93\u5bb9\u5dee\uff08%\uff09,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:UFDouble-->\n            <outtolerance>0.00000000</outtolerance>\n            <!--\u51fa\u5e93\u5173\u95ed\u4e0b\u5bb9\u5dee\uff08%\uff09,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:UFDouble-->\n            <outcloselowerlimit>0.00000000</outcloselowerlimit>\n            <!--\u4ea7\u54c1\u7c07,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n            <productfamily>N</productfamily>\n            <!--\u7a0e\u7c7b,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <pk_mattaxes>KGPT04</pk_mattaxes>\n            <!--\u7535\u5b50\u91c7\u8d2d,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n            <iselectrans>N</iselectrans>\n            <!--\u5b9e\u7269\u7269\u6599\u7ba1\u7406\u6a21\u5f0f,\u6700\u5927\u957f\u5ea6\u4e3a0,\u7c7b\u578b\u4e3a:Integer-->\n            <materialmgt>0</materialmgt>\n            <memo>\n            </memo>\n            <!--\u542f\u7528\u72b6\u6001,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:Integer 2\u4e3a\u542f\u7528\uff0c3\u4e3a\u505c\u7528-->\n            <enablestate>2</enablestate>\n            <materialconvert>\n                <item>\n                    <!--\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n                    <pk_measdoc>KGM</pk_measdoc>\n                    <!--\u4e0e\u4e3b\u8ba1\u91cf\u5355\u4f4d\u6362\u7b97\u7cfb\u6570,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a50,\u7c7b\u578b\u4e3a:String-->\n                    <measrate>1/1</measrate>\n                    <!--\u56fa\u5b9a\u6362\u7b97,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n                    <fixedflag>N</fixedflag>\n                    <!--\u7ed3\u5b58,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n                    <isstorebalance>N</isstorebalance>\n                    <!--\u91c7\u8d2d\u9ed8\u8ba4\u5355\u4f4d,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n                    <ispumeasdoc>N</ispumeasdoc>\n                    <!--\u751f\u4ea7\u9ed8\u8ba4\u5355\u4f4d,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n                    <isprodmeasdoc>N</isprodmeasdoc>\n                    <!--\u5e93\u5b58\u9ed8\u8ba4\u5355\u4f4d,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n                    <isstockmeasdoc>N</isstockmeasdoc>\n                    <!--\u9500\u552e\u9ed8\u8ba4\u5355\u4f4d,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n                    <issalemeasdoc>N</issalemeasdoc>\n                    <!--\u96f6\u552e\u9ed8\u8ba4\u5355\u4f4d,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n                    <isretailmeasdoc>N</isretailmeasdoc>\n                    <!--\u4ef6\u6570\u7ba1\u7406,\u6700\u5927\u957f\u5ea6\u4e3a1,\u7c7b\u578b\u4e3a:UFBoolean-->\n                    <ispiecemangage>N</ispiecemangage>\n                </item>\n            </materialconvert>\n            <materialtaxtype>\n                <item>\n                    <!--\u56fd\u5bb6\u540d\u79f0,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n                    <pk_countryzone>CN</pk_countryzone>\n                    <!--\u7a0e\u7c7b\u540d\u79f0,\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n                    <pk_mattaxes>KGPT04</pk_mattaxes>\n                </item>\n            </materialtaxtype>\n            <!--\u8f85\u52a9\u5c5e\u6027\u7ed3\u6784,\u6700\u5927\u957f\u5ea6\u4e3a20,\u7c7b\u578b\u4e3a:String-->\n            <pk_marasstframe></pk_marasstframe>\n        </billhead>\n    </bill>\n</ufinterface>";
        MaterialUfInterface materialUfInterface = XmlConverter.convertXmlToJava(xml, MaterialUfInterface.class);
        XmlConverter.sendRequest(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendRequest(String xmlParam) {
        String responseXml;
        block57: {
            responseXml = "";
            String realURL = "http://39.99.147.197:6789";
            HttpURLConnection con = null;
            int responseCode = -1;
            try {
                con = (HttpURLConnection)new URL(realURL).openConnection();
                con.setDoOutput(true);
                con.setDoInput(true);
                con.setAllowUserInteraction(false);
                con.setUseCaches(false);
                con.setRequestProperty("Content-type", "text/xml");
                con.setRequestMethod("POST");
                try (DataOutputStream dos = new DataOutputStream(con.getOutputStream());){
                    dos.write(xmlParam.getBytes("GBK"));
                    dos.flush();
                }
                responseCode = con.getResponseCode();
                if (responseCode == 200) {
                    var6_7 = null;
                    try (InputStream in = con.getInputStream();
                         InputStreamReader isr = new InputStreamReader(in, "GBK");
                         BufferedReader br = new BufferedReader(isr);){
                        String line;
                        StringBuilder rexml = new StringBuilder();
                        while ((line = br.readLine()) != null) {
                            rexml.append(line);
                        }
                        responseXml = rexml.toString();
                        break block57;
                    }
                    catch (Throwable throwable) {
                        var6_7 = throwable;
                        throw throwable;
                    }
                }
                log.info("\u8fde\u63a5\u5931\u8d25:{}", (Object)responseCode);
            }
            catch (IOException e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u65f6\u53d1\u751f I/O \u5f02\u5e38: ", (Throwable)e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
                log.info("\u8bf7\u6c42\u7ed3\u675f\uff0c\u54cd\u5e94\u7ed3\u679c: {}", (Object)responseXml);
            }
        }
        return responseXml;
    }
}

