/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.EhcacheUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy(value=false)
public class CacheUtil {
    private static final Logger log = LoggerFactory.getLogger(CacheUtil.class);
    private CacheType cacheType;
    @Autowired
    private CacheProperties cacheProperties;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private EhcacheUtil ehcacheUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;

    public CacheType getCacheType() {
        if (ObjectUtil.isEmpty((Object)this.cacheType)) {
            this.cacheType = this.cacheProperties.getType();
        }
        return this.cacheType;
    }

    public void setType(CacheType cacheType) {
        this.cacheType = cacheType;
    }

    @Bean
    @ConditionalOnClass(value={CacheProperties.class})
    public void initCacheType() {
        this.cacheType = this.cacheProperties.getType();
        log.info("CacheUtil spring.cache.type\uff1a" + this.cacheType);
    }

    public void insert(String cacheName, String key, Object value) {
        switch (this.cacheType) {
            case EHCACHE: {
                this.ehcacheUtil.insert(cacheName, key, value);
                break;
            }
            case REDIS: {
                this.redisUtil.insert(key, value);
                break;
            }
        }
    }

    public void insert(String cacheName, String key, Object value, long time) {
        switch (this.cacheType) {
            case EHCACHE: {
                this.ehcacheUtil.insert(cacheName, key, value, (int)time);
                break;
            }
            case REDIS: {
                this.redisUtil.insert(key, value, time);
                break;
            }
        }
    }

    public void expire(String cacheName, String key, int time) {
        switch (this.cacheType) {
            case EHCACHE: {
                this.ehcacheUtil.expire(cacheName, key, time);
                break;
            }
            case REDIS: {
                this.redisUtil.expire(key, time);
                break;
            }
        }
    }

    public void remove(String key) {
        switch (this.cacheType) {
            case EHCACHE: {
                this.ehcacheUtil.remove(key);
                break;
            }
            case REDIS: {
                this.redisUtil.remove(key);
                break;
            }
        }
    }

    public void remove(String cacheName, String key) {
        if (StringUtils.isNotEmpty(key)) {
            switch (this.cacheType) {
                case EHCACHE: {
                    this.ehcacheUtil.remove(cacheName, key);
                    break;
                }
                case REDIS: {
                    this.redisUtil.remove(key);
                    break;
                }
            }
        }
    }

    public void removeHash(String cacheName, String hashId, String key) {
        switch (this.cacheType) {
            case EHCACHE: {
                this.ehcacheUtil.removeHash(cacheName, key);
                break;
            }
            case REDIS: {
                this.redisUtil.removeHash(hashId, key);
                break;
            }
        }
    }

    public Object query(String key) {
        if (StringUtils.isNotEmpty(key)) {
            switch (this.cacheType) {
                case EHCACHE: {
                    return this.ehcacheUtil.query(key);
                }
                case REDIS: {
                    return this.redisUtil.getString(key);
                }
            }
            return null;
        }
        return null;
    }

    public Object query(String cacheName, String key) {
        if (StringUtils.isNotEmpty(cacheName) && StringUtils.isNotEmpty(key)) {
            switch (this.cacheType) {
                case EHCACHE: {
                    return this.ehcacheUtil.query(cacheName, key);
                }
                case REDIS: {
                    return this.redisUtil.getString(key);
                }
            }
            return null;
        }
        return null;
    }

    public <K, V> Map<K, V> getMap(String key) {
        if (StringUtils.isNotEmpty(key)) {
            switch (this.cacheType) {
                case EHCACHE: {
                    return this.ehcacheUtil.getMap(key);
                }
                case REDIS: {
                    return this.redisUtil.getMap(key);
                }
            }
            return null;
        }
        return null;
    }

    public List<Object> getList(String key, long start, long end) {
        try {
            if (StringUtils.isNotEmpty(key)) {
                switch (this.cacheType) {
                    case EHCACHE: {
                        return this.ehcacheUtil.getList(key);
                    }
                    case REDIS: {
                        return this.redisUtil.get(key, start, end);
                    }
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            log.error(key, (Throwable)e);
            return null;
        }
    }

    public Set<Object> getSet(String key) {
        try {
            if (StringUtils.isNotEmpty(key)) {
                switch (this.cacheType) {
                    case EHCACHE: {
                        return this.ehcacheUtil.getSet(key);
                    }
                    case REDIS: {
                        return this.redisUtil.getSet(key);
                    }
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            log.error(key, (Throwable)e);
            return null;
        }
    }

    public boolean exists(String key) {
        return this.exists(null, key);
    }

    public boolean exists(String cacheName, String key) {
        if (StringUtils.isNotEmpty(key)) {
            switch (this.cacheType) {
                case EHCACHE: {
                    return this.ehcacheUtil.exists(cacheName, key);
                }
                case REDIS: {
                    return this.redisUtil.exists(key);
                }
            }
            return false;
        }
        return false;
    }

    public Set<String> getAllKeys() {
        return this.getAllKeys(null);
    }

    public Set<String> getAllKeys(String cacheName) {
        Set<String> keys = null;
        switch (this.cacheType) {
            case EHCACHE: {
                keys = this.ehcacheUtil.getAllKeys(cacheName);
                break;
            }
            case REDIS: {
                keys = this.redisUtil.getAllKeys();
                break;
            }
        }
        return keys;
    }

    public Set<String> getAllVisiualKeys() {
        Set<String> allKey = new HashSet<String>(16);
        switch (this.cacheType) {
            case EHCACHE: {
                allKey = this.ehcacheUtil.getAllVisiualKeys();
                break;
            }
            case REDIS: {
                allKey = this.redisUtil.getAllVisiualKeys();
                break;
            }
        }
        return allKey;
    }

    public Long getLiveTime(String key) {
        switch (this.cacheType) {
            case EHCACHE: {
                return this.ehcacheUtil.getLiveTime(key);
            }
            case REDIS: {
                return new Date((DateUtil.getTime(new Date()) + this.redisUtil.getLiveTime(key)) * 1000L).getTime();
            }
        }
        return 0L;
    }

    public Boolean setStringByAtomicity(String key, String value, Long timeout, TimeUnit timeUnit) throws Exception {
        switch (this.cacheType) {
            case EHCACHE: {
                return this.ehcacheUtil.setStringByAtomicity(key, value);
            }
            case REDIS: {
                return this.redisUtil.setStringByAtomicity(key, value, timeout, TimeUnit.MILLISECONDS);
            }
        }
        return false;
    }
}

