/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.capture.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.capture.entity.DaapCaptureConfigEntity;
import com.bringspring.daap.capture.model.config.CaptureConfigDetail;
import com.bringspring.daap.capture.model.config.CaptureConfigModel;
import com.bringspring.daap.capture.model.config.DaapCaptureConfigListVO;
import com.bringspring.daap.capture.model.config.DaapCaptureConfigPagination;
import com.bringspring.daap.capture.model.config.FlinkJobDetailQuery;
import com.bringspring.daap.capture.model.mapping.MappingFieldModel;
import com.bringspring.daap.capture.model.mapping.MappingTableQueryModel;
import com.bringspring.daap.capture.service.DaapCaptureConfigService;
import com.bringspring.daap.capture.service.DaapCaptureTableMappingService;
import com.bringspring.daap.job.entity.DaapFlinkExcepointEntity;
import com.bringspring.daap.job.entity.DaapFlinkManagerInfoEntity;
import com.bringspring.daap.job.entity.DaapFlinkSavepointEntity;
import com.bringspring.daap.job.service.DaapFlinkCheckpointService;
import com.bringspring.daap.job.service.DaapFlinkExcepointService;
import com.bringspring.daap.job.service.DaapFlinkManagerInfoService;
import com.bringspring.daap.job.service.DaapJobClusterService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6570\u636e\u91c7\u96c6\u914d\u7f6e"}, value="daap")
@RequestMapping(value={"/api/daap/DaapCaptureConfig"})
public class DaapCaptureConfigController {
    private static final Logger log = LoggerFactory.getLogger(DaapCaptureConfigController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapCaptureConfigService daapCaptureConfigService;
    @Autowired
    private DaapCaptureTableMappingService daapCaptureTableMappingService;
    @Autowired
    private DaapJobClusterService daapJobClusterService;
    @Autowired
    private DaapFlinkCheckpointService daappFlinkCheckpointService;
    @Autowired
    private DaapFlinkExcepointService flinkExcepointService;
    @Autowired
    private DaapFlinkManagerInfoService daapFlinkManagerInfoService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapCaptureConfigPagination daapCaptureConfigPagination) throws IOException {
        List<DaapCaptureConfigEntity> list = this.daapCaptureConfigService.getList(daapCaptureConfigPagination);
        for (DaapCaptureConfigEntity entity : list) {
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setLastModifyUserId(this.baseDataUtil.userSelectValue(entity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, DaapCaptureConfigListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapCaptureConfigPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody CaptureConfigModel captureConfigModel) throws DataException {
        String id = this.daapCaptureConfigService.create(captureConfigModel);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f", (Object)id);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CaptureConfigModel> getCaptureConfigInfo(@PathVariable(value="id") String id) throws Exception {
        CaptureConfigModel captureConfigInfo = this.daapCaptureConfigService.getCaptureConfigInfo(id);
        if (captureConfigInfo.getStep() > 3) {
            Map<String, String> sqlMap = this.daapCaptureConfigService.getCaptureFlinkSql(captureConfigInfo);
            captureConfigInfo.setCreateContent(sqlMap.get("creatTableSql"));
            if (StringUtils.isEmpty((String)captureConfigInfo.getEtlContent())) {
                captureConfigInfo.setEtlContent(sqlMap.get("syncTableSql"));
            }
        }
        return ActionResult.success((Object)captureConfigInfo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CaptureConfigDetail> getCaptureConfigDetail(@PathVariable(value="id") String id) throws Exception {
        CaptureConfigDetail captureConfigDetail = this.daapCaptureConfigService.getCaptureConfigDetail(id);
        return ActionResult.success((Object)captureConfigDetail);
    }

    @PostMapping(value={"/job"})
    public ActionResult<JSONObject> getFlinkJobDetail(@RequestBody FlinkJobDetailQuery jobDetailQuery) throws Exception {
        JSONObject jobDetail = this.daapCaptureConfigService.getFlinkJobDetail(jobDetailQuery.getJobId(), jobDetailQuery.getFlinkHost(), jobDetailQuery.getFlinkPort());
        return ActionResult.success((Object)jobDetail);
    }

    @PostMapping(value={"/jobByDb"})
    public ActionResult<JSONObject> getFlinkJobDetailByDb(@RequestBody FlinkJobDetailQuery jobDetailQuery) throws Exception {
        DaapFlinkManagerInfoEntity daapFlinkManagerInfoEntity = this.daapFlinkManagerInfoService.getDaapFlinkManagerInfoByJobId(jobDetailQuery.getJobId());
        String managerInfo = "";
        if (daapFlinkManagerInfoEntity != null) {
            managerInfo = daapFlinkManagerInfoEntity.getManagerInfo();
        }
        JSONObject jobDetail = JSONObject.parseObject((String)managerInfo);
        return ActionResult.success((Object)jobDetail);
    }

    @PutMapping(value={"/updateCaptureConfig"})
    public ActionResult updateCaptureConfig(@RequestBody @Valid CaptureConfigModel captureConfigModel) throws DataException {
        this.daapCaptureConfigService.updateCaptureConfig(captureConfigModel);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"/startCapture"})
    public ActionResult startCapture(@RequestBody String json) throws Exception {
        JSONObject startCaptureJson = JSONObject.parseObject((String)json);
        String id = startCaptureJson.getString("id");
        String checkOrSavePath = startCaptureJson.getString("checkOrSavePath");
        this.daapCaptureConfigService.submitCapture(id, checkOrSavePath);
        return ActionResult.success((String)"\u63d0\u4ea4\u4efb\u52a1\u6210\u529f");
    }

    @PostMapping(value={"/job/stop"})
    public ActionResult<JSONObject> stopJob(@RequestBody FlinkJobDetailQuery jobDetailQuery) throws Exception {
        String result = this.daapCaptureConfigService.getFlinkSavePointAndStopJob(jobDetailQuery.getJobId(), jobDetailQuery.getFlinkHost(), jobDetailQuery.getFlinkPort());
        if (StringUtils.isNotEmpty((String)result)) {
            // empty if block
        }
        return ActionResult.success();
    }

    @PostMapping(value={"/job/exception"})
    public ActionResult<JSONObject> jobException(@RequestBody FlinkJobDetailQuery jobDetailQuery) throws Exception {
        JSONObject jobException = this.daapCaptureConfigService.getJobException(jobDetailQuery.getJobId(), jobDetailQuery.getFlinkHost(), jobDetailQuery.getFlinkPort(), jobDetailQuery.getMax());
        return ActionResult.success((Object)jobException);
    }

    @PostMapping(value={"/job/exceptionByDb"})
    public ActionResult<JSONObject> jobExceptionByDb(@RequestBody FlinkJobDetailQuery jobDetailQuery) throws Exception {
        DaapFlinkExcepointEntity daapFlinkExcepointEntity = this.flinkExcepointService.getDaapFlinkExcepointByJobId(jobDetailQuery.getJobId());
        String excepoints = "";
        if (daapFlinkExcepointEntity != null) {
            excepoints = daapFlinkExcepointEntity.getExcepointInfo();
        }
        JSONObject excepointJson = JSONObject.parseObject((String)excepoints);
        return ActionResult.success((Object)excepointJson);
    }

    @PostMapping(value={"/job/checkpoint"})
    public ActionResult<JSONObject> checkpoint(@RequestBody FlinkJobDetailQuery jobDetailQuery) throws Exception {
        JSONObject jobCheckPoint = this.daapCaptureConfigService.getJobCheckPoint(jobDetailQuery.getJobId(), jobDetailQuery.getFlinkHost(), jobDetailQuery.getFlinkPort());
        return ActionResult.success((Object)jobCheckPoint);
    }

    @PostMapping(value={"/job/checkpointByDb"})
    public ActionResult<JSONObject> checkpointByDb(@RequestBody FlinkJobDetailQuery jobDetailQuery) throws Exception {
        JSONObject jobCheckPoint = this.daapCaptureConfigService.checkpointByDb(jobDetailQuery.getJobId());
        return ActionResult.success((Object)jobCheckPoint);
    }

    @PostMapping(value={"/job/savepointByDb"})
    public ActionResult<List<DaapFlinkSavepointEntity>> savepointByDb(@RequestBody FlinkJobDetailQuery jobDetailQuery) throws Exception {
        List<Object> resultList = new ArrayList();
        List<DaapFlinkSavepointEntity> daapFlinkSavepointEntityList = this.daapCaptureConfigService.savepointByDb(jobDetailQuery.getJobId());
        Collections.reverse(daapFlinkSavepointEntityList);
        resultList = daapFlinkSavepointEntityList.size() > 10 ? daapFlinkSavepointEntityList.subList(0, 10) : daapFlinkSavepointEntityList;
        return ActionResult.success(resultList);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DaapCaptureConfigEntity entity = this.daapCaptureConfigService.getInfo(id);
        if (entity != null) {
            this.daapCaptureConfigService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getMappingTableFieldList"})
    public ActionResult<MappingFieldModel> getMappingTableFieldList(@RequestBody MappingTableQueryModel mappingTableQueryModel) throws DataException, SQLException {
        MappingFieldModel mappingTableField = StringUtils.isNotEmpty((String)mappingTableQueryModel.getId()) ? this.daapCaptureTableMappingService.getMappingTableField(mappingTableQueryModel.getSourceModel().getConnectorId(), mappingTableQueryModel.getId(), mappingTableQueryModel.getSourceTable().getDbName(), mappingTableQueryModel.getSourceTable().getSchemaName(), mappingTableQueryModel.getSourceTable().getTableName()) : this.daapCaptureTableMappingService.getDefaultMappingTableField(mappingTableQueryModel.getSourceModel().getConnectorId(), mappingTableQueryModel.getSourceTable().getDbName(), mappingTableQueryModel.getSourceTable().getSchemaName(), mappingTableQueryModel.getSourceTable().getTableName());
        return ActionResult.success((Object)mappingTableField);
    }
}

